/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.lib.ModTags;

public class ItemMagnetRing
extends ItemBauble {
    private static final String TAG_COOLDOWN = "cooldown";
    private final int range;

    public ItemMagnetRing(Item.Properties props) {
        this(props, 6);
        MinecraftForge.EVENT_BUS.addListener(this::onTossItem);
    }

    public ItemMagnetRing(Item.Properties props, int range) {
        super(props);
        this.range = range;
        this.func_185043_a(new ResourceLocation("botania", "on"), (stack, worldIn, entityIn) -> ItemMagnetRing.getCooldown(stack) <= 0 ? 1.0f : 0.0f);
    }

    private void onTossItem(ItemTossEvent event) {
        ItemStack ring = EquipmentHandler.findOrEmpty(s -> s.func_77973_b() instanceof ItemMagnetRing, (LivingEntity)event.getPlayer());
        if (!ring.func_190926_b()) {
            ItemMagnetRing.setCooldown(ring, 100);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        super.onWornTick(stack, living);
        if (living.func_175149_v()) {
            return;
        }
        int cooldown = ItemMagnetRing.getCooldown(stack);
        if (SubTileSolegnolia.hasSolegnoliaAround((Entity)living)) {
            if (cooldown < 0) {
                ItemMagnetRing.setCooldown(stack, 2);
            }
            return;
        }
        if (cooldown <= 0) {
            if (living.func_225608_bj_() == ((Boolean)ConfigHandler.COMMON.invertMagnetRing.get()).booleanValue()) {
                double x = living.func_226277_ct_();
                double y = living.func_226278_cu_() + 0.75;
                double z = living.func_226281_cx_();
                int range = ((ItemMagnetRing)stack.func_77973_b()).range;
                List items = living.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
                int pulled = 0;
                for (ItemEntity item : items) {
                    if (!((ItemMagnetRing)stack.func_77973_b()).canPullItem(item)) continue;
                    if (pulled <= 200) {
                        MathHelper.setEntityMotionFromVector((Entity)item, new Vector3(x, y, z), 0.45f);
                        if (living.field_70170_p.field_72995_K) {
                            boolean red = living.field_70170_p.field_73012_v.nextBoolean();
                            float r = red ? 1.0f : 0.0f;
                            float b = red ? 0.0f : 1.0f;
                            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, 0.0f, b, 3);
                            living.field_70170_p.func_195594_a((IParticleData)data, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), 0.0, 0.0, 0.0);
                        }
                        ++pulled;
                        continue;
                    }
                    break;
                }
            }
        } else {
            ItemMagnetRing.setCooldown(stack, cooldown - 1);
        }
    }

    private boolean canPullItem(ItemEntity item) {
        if (!item.func_70089_S() || item.field_145804_b >= 40 || SubTileSolegnolia.hasSolegnoliaAround((Entity)item) || item.getPersistentData().func_74767_n("PreventRemoteMovement")) {
            return false;
        }
        ItemStack stack = item.func_92059_d();
        if (stack.func_190926_b() || stack.func_77973_b() instanceof IManaItem || stack.func_77973_b() instanceof IRelic || ModTags.Items.MAGNET_RING_BLACKLIST.func_199685_a_((Object)stack.func_77973_b())) {
            return false;
        }
        BlockPos pos = new BlockPos((Entity)item);
        if (ModTags.Blocks.MAGNET_RING_BLACKLIST.func_199685_a_((Object)item.field_70170_p.func_180495_p(pos).func_177230_c())) {
            return false;
        }
        return !ModTags.Blocks.MAGNET_RING_BLACKLIST.func_199685_a_((Object)item.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    public static int getCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }
}

