/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.core.helper.PlayerHelper;

public class ItemSpawnerMover
extends Item {
    private static final String TAG_SPAWNER = "spawner";
    private static final String TAG_SPAWN_DATA = "SpawnData";
    private static final String TAG_ID = "id";

    public ItemSpawnerMover(Item.Properties props) {
        super(props);
        this.func_185043_a(new ResourceLocation("botania", "full"), (stack, worldIn, entityIn) -> ItemSpawnerMover.hasData(stack) ? 1.0f : 0.0f);
    }

    @Nullable
    private static ResourceLocation getEntityId(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a(TAG_SPAWNER);
        if (tag != null && tag.func_74764_b(TAG_SPAWN_DATA) && (tag = tag.func_74775_l(TAG_SPAWN_DATA)).func_74764_b(TAG_ID)) {
            return ResourceLocation.func_208304_a((String)tag.func_74779_i(TAG_ID));
        }
        return null;
    }

    private static boolean hasData(ItemStack stack) {
        return ItemSpawnerMover.getEntityId(stack) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> infoList, ITooltipFlag flags) {
        EntityType type;
        ResourceLocation id = ItemSpawnerMover.getEntityId(stack);
        if (id != null && (type = (EntityType)ForgeRegistries.ENTITIES.getValue(id)) != null) {
            infoList.add(type.func_212546_e());
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ItemSpawnerMover.getEntityId(ctx.func_195996_i()) == null) {
            return this.captureSpawner(ctx) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return this.placeSpawner(ctx);
    }

    private ActionResultType placeSpawner(ItemUseContext ctx) {
        ItemStack useStack = new ItemStack((IItemProvider)Blocks.field_150474_ac);
        useStack.func_196082_o().func_218657_a("BlockEntityTag", (INBT)ctx.func_195996_i().func_179543_a(TAG_SPAWNER));
        ActionResultType res = PlayerHelper.substituteUse(ctx, useStack);
        if (res == ActionResultType.SUCCESS) {
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            ItemStack mover = ctx.func_195996_i();
            if (!world.field_72995_K) {
                if (ctx.func_195999_j() != null) {
                    ctx.func_195999_j().func_213334_d(ctx.func_221531_n());
                }
                mover.func_190918_g(1);
            } else {
                for (int i = 0; i < 100; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle(0.45f + 0.2f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 6);
                    world.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
        return res;
    }

    private boolean captureSpawner(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150474_ac) {
            if (!world.field_72995_K) {
                TileEntity te = world.func_175625_s(pos);
                stack.func_196082_o().func_218657_a(TAG_SPAWNER, (INBT)te.func_189515_b(new CompoundNBT()));
                world.func_175655_b(pos, false);
                if (player != null) {
                    player.func_184811_cZ().func_185145_a((Item)this, 20);
                    UseItemSuccessTrigger.INSTANCE.trigger((ServerPlayerEntity)player, stack, (ServerWorld)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    player.func_213334_d(ctx.func_221531_n());
                }
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.1f + 0.05f, red, green, blue);
                    world.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f));
                }
            }
            return true;
        }
        return false;
    }
}

