/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.block.tile.mana.TilePump;
import vazkii.botania.common.item.ModItems;

public class EntityPoolMinecart
extends AbstractMinecartEntity {
    @ObjectHolder(value="botania:pool_minecart")
    public static EntityType<EntityPoolMinecart> TYPE;
    private static final int TRANSFER_RATE = 10000;
    private static final String TAG_MANA = "mana";
    private static final DataParameter<Integer> MANA;

    public EntityPoolMinecart(EntityType<EntityPoolMinecart> type, World world) {
        super(type, world);
    }

    public EntityPoolMinecart(World world, double x, double y, double z) {
        super(TYPE, world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MANA, (Object)0);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public BlockState func_174897_t() {
        return ModBlocks.manaPool.func_176223_P();
    }

    @Nonnull
    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)ModItems.poolMinecart);
    }

    @Nonnull
    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.RIDEABLE;
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void func_94101_h() {
        float f = 0.98f;
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)f, 0.0, (double)f));
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ModItems.poolMinecart);
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        this.func_199702_a((IItemProvider)ModBlocks.manaPool, 0);
    }

    public int func_94085_r() {
        return 8;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            double particleChance = 1.0 - (double)this.getMana() / 1000000.0 * 0.1;
            int color = 50943;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            double x = MathHelper.func_76128_c((double)this.func_226277_ct_());
            double y = MathHelper.func_76128_c((double)this.func_226278_cu_());
            double z = MathHelper.func_76128_c((double)this.func_226281_cx_());
            if (Math.random() > particleChance) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, red, green, blue, 2.0f);
                this.field_70170_p.func_195594_a((IParticleData)data, x + 0.3 + Math.random() * 0.5, y + 0.85 + Math.random() * 0.25, z + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
            }
        }
    }

    public void moveMinecartOnRail(BlockPos pos) {
        super.moveMinecartOnRail(pos);
        for (Direction dir : vazkii.botania.common.core.helper.MathHelper.HORIZONTALS) {
            int cartMana;
            BlockPos posP = pos.func_177972_a(dir);
            Block block = this.field_70170_p.func_180495_p(posP).func_177230_c();
            if (block != ModBlocks.pump) continue;
            BlockPos posP_ = posP.func_177972_a(dir);
            TileEntity tile = this.field_70170_p.func_175625_s(posP_);
            TileEntity tile_ = this.field_70170_p.func_175625_s(posP);
            TilePump pump = (TilePump)tile_;
            if (!(tile instanceof IManaPool)) continue;
            IManaPool pool = (IManaPool)tile;
            Direction pumpDir = (Direction)this.field_70170_p.func_180495_p(posP).func_177229_b(BotaniaStateProps.CARDINALS);
            boolean did = false;
            boolean can = false;
            if (pumpDir == dir) {
                int poolMana;
                int transfer;
                int actualTransfer;
                can = true;
                if (!pump.hasRedstone && (actualTransfer = Math.min(1000000 - (cartMana = this.getMana()), transfer = Math.min(10000, poolMana = pool.getCurrentMana()))) > 0) {
                    pool.recieveMana(-transfer);
                    this.setMana(cartMana + actualTransfer);
                    did = true;
                }
            } else if (pumpDir == dir.func_176734_d()) {
                int transfer;
                can = true;
                if (!pump.hasRedstone && !pool.isFull() && (transfer = Math.min(10000, cartMana = this.getMana())) > 0) {
                    pool.recieveMana(transfer);
                    this.setMana(cartMana - transfer);
                    did = true;
                }
            }
            if (did) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_70170_p, posP_);
                pump.hasCart = true;
                if (!pump.active) {
                    pump.setActive(true);
                }
            }
            if (!can) continue;
            pump.hasCartOnTop = true;
            pump.comparator = (int)((double)this.getMana() / 1000000.0 * 15.0);
        }
    }

    protected void func_213281_b(@Nonnull CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74768_a(TAG_MANA, this.getMana());
    }

    protected void func_70037_a(CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.setMana(cmp.func_74762_e(TAG_MANA));
    }

    public int getComparatorLevel() {
        return TilePool.calculateComparatorLevel(this.getMana(), 1000000);
    }

    public int getMana() {
        return (Integer)this.field_70180_af.func_187225_a(MANA);
    }

    public void setMana(int mana) {
        this.field_70180_af.func_187227_b(MANA, (Object)mana);
    }

    static {
        MANA = EntityDataManager.func_187226_a(EntityPoolMinecart.class, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

