/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.item.ModItems;

public class ManaGunClipRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<ManaGunClipRecipe> SERIALIZER = new SpecialRecipeSerializer(ManaGunClipRecipe::new);

    public ManaGunClipRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundGun = false;
        boolean foundClip = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemManaGun && !ItemManaGun.hasClip(stack)) {
                foundGun = true;
                continue;
            }
            if (stack.func_77973_b() == ModItems.clip) {
                foundClip = true;
                continue;
            }
            return false;
        }
        return foundGun && foundClip;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack gun = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemManaGun)) continue;
            gun = stack;
        }
        if (gun.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack lens = ItemManaGun.getLens(gun);
        ItemManaGun.setLens(gun, ItemStack.field_190927_a);
        ItemStack gunCopy = gun.func_77946_l();
        ItemManaGun.setClip(gunCopy, true);
        ItemManaGun.setLensAtPos(gunCopy, lens, 0);
        return gunCopy;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

