/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.material.ItemRune;

public class TileRuneAltar
extends TileSimpleInventory
implements IManaReceiver,
ITickableTileEntity {
    @ObjectHolder(value="botania:runic_altar")
    public static TileEntityType<TileRuneAltar> TYPE;
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_TO_GET = "manaToGet";
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int SET_COOLDOWN_EVENT = 1;
    private static final int CRAFT_EFFECT_EVENT = 2;
    private RecipeRuneAltar currentRecipe;
    public int manaToGet = 0;
    private int mana = 0;
    private int cooldown = 0;
    public int signal = 0;
    private List<ItemStack> lastRecipe = null;
    private int recipeKeepTicks = 0;

    public TileRuneAltar() {
        super(TYPE);
    }

    public boolean addItem(@Nullable PlayerEntity player, ItemStack stack, @Nullable Hand hand) {
        if (this.cooldown > 0 || stack.func_77973_b() == ModItems.twigWand || stack.func_77973_b() == ModItems.lexicon) {
            return false;
        }
        if (stack.func_77973_b() == ModBlocks.livingrock.func_199767_j()) {
            if (!this.field_145850_b.field_72995_K) {
                ItemStack toSpawn = player != null && player.field_71075_bZ.field_75098_d ? stack.func_77946_l().func_77979_a(1) : stack.func_77979_a(1);
                ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, toSpawn);
                item.func_174867_a(40);
                item.func_213317_d(Vec3d.field_186680_a);
                this.field_145850_b.func_217376_c((Entity)item);
            }
            return true;
        }
        if (this.manaToGet != 0) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            did = true;
            ItemStack stackToAdd = stack.func_77946_l();
            stackToAdd.func_190920_e(1);
            this.itemHandler.setStackInSlot(i, stackToAdd);
            if (player != null && player.field_71075_bZ.field_75098_d) break;
            stack.func_190918_g(1);
            break;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
        return true;
    }

    public boolean func_145842_c(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                this.cooldown = param;
                return true;
            }
            case 2: {
                if (this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.runeAltarCraft, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.func_145842_c(id, param);
    }

    public void func_73660_a() {
        this.recieveMana(0);
        if (!this.field_145850_b.field_72995_K) {
            if (this.manaToGet == 0) {
                List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
                for (ItemEntity item : items) {
                    if (!item.func_70089_S() || item.func_92059_d().func_190926_b() || item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)ModBlocks.livingrock)) continue;
                    ItemStack stack = item.func_92059_d();
                    this.addItem(null, stack, null);
                }
            }
            int newSignal = 0;
            if (this.manaToGet > 0) {
                ++newSignal;
                if (this.mana >= this.manaToGet) {
                    ++newSignal;
                }
            }
            if (newSignal != this.signal) {
                this.signal = newSignal;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
            this.updateRecipe();
        } else {
            if (this.manaToGet > 0 && this.mana >= this.manaToGet && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                Vector3 vec = Vector3.fromTileEntityCenter(this);
                Vector3 endVec = vec.add(0.0, 2.5, 0.0);
                Botania.proxy.lightningFX(vec, endVec, 2.0f, 38027, 58583);
            }
            if (this.cooldown > 0) {
                WispParticleData data = WispParticleData.wisp(0.2f, 0.2f, 0.2f, 0.2f, 1.0f);
                this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + Math.random(), (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + Math.random(), 0.0, (double)0.025f, 0.0);
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    private void updateRecipe() {
        int manaToGet;
        block4: {
            manaToGet = this.manaToGet;
            if (this.currentRecipe != null) {
                this.manaToGet = this.currentRecipe.getManaUsage();
            } else {
                for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes.values()) {
                    if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                    this.manaToGet = recipe.getManaUsage();
                    break block4;
                }
                this.manaToGet = 0;
            }
        }
        if (manaToGet != this.manaToGet) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.runeAltarStart, SoundCategory.BLOCKS, 1.0f, 1.0f);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
    }

    private void saveLastRecipe() {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSizeInventory() && !(stack = this.itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
            this.lastRecipe.add(stack.func_77946_l());
        }
        this.recipeKeepTicks = 400;
        this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.runeAltar, 0, 400);
    }

    public void trySetLastRecipe(PlayerEntity player) {
        TileAltar.tryToSetLastRecipe(player, (IItemHandlerModifiable)this.itemHandler, this.lastRecipe);
        if (!this.isEmpty()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean hasValidRecipe() {
        for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes.values()) {
            if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
            return true;
        }
        return false;
    }

    public void onWanded(PlayerEntity player, ItemStack wand) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        RecipeRuneAltar recipe = null;
        if (this.currentRecipe != null) {
            recipe = this.currentRecipe;
        } else {
            for (RecipeRuneAltar recipe_ : BotaniaAPI.runeAltarRecipes.values()) {
                if (!recipe_.matches((IItemHandler)this.itemHandler)) continue;
                recipe = recipe_;
                break;
            }
        }
        if (this.manaToGet > 0 && this.mana >= this.manaToGet) {
            List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
            ItemEntity livingrock = null;
            for (ItemEntity item : items) {
                if (!item.func_70089_S() || item.func_92059_d().func_190926_b() || item.func_92059_d().func_77973_b() != ModBlocks.livingrock.func_199767_j()) continue;
                livingrock = item;
                break;
            }
            if (livingrock != null) {
                int mana = recipe.getManaUsage();
                this.recieveMana(-mana);
                ItemStack output = recipe.getOutput().func_77946_l();
                ItemEntity outputItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                this.field_145850_b.func_217376_c((Entity)outputItem);
                this.currentRecipe = null;
                this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.runeAltar, 1, 60);
                this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.runeAltar, 2, 0);
                this.saveLastRecipe();
                for (int i = 0; i < this.getSizeInventory(); ++i) {
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    if (stack.func_77973_b() instanceof ItemRune && (player == null || !player.field_71075_bZ.field_75098_d)) {
                        ItemEntity outputRune = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, stack.func_77946_l());
                        this.field_145850_b.func_217376_c((Entity)outputRune);
                    }
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                livingrock.func_92059_d().func_190918_g(1);
            }
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writePacketNBT(CompoundNBT tag) {
        super.writePacketNBT(tag);
        tag.func_74768_a(TAG_MANA, this.mana);
        tag.func_74768_a(TAG_MANA_TO_GET, this.manaToGet);
    }

    @Override
    public void readPacketNBT(CompoundNBT tag) {
        super.readPacketNBT(tag);
        this.mana = tag.func_74762_e(TAG_MANA);
        this.manaToGet = tag.func_74762_e(TAG_MANA_TO_GET);
    }

    @Override
    public int getSizeInventory() {
        return 16;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaToGet;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.manaToGet);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public void renderHUD(Minecraft mc) {
        int xc = mc.func_228018_at_().func_198107_o() / 2;
        int yc = mc.func_228018_at_().func_198087_p() / 2;
        float angle = -90.0f;
        int radius = 24;
        int amt = 0;
        for (int i = 0; i < this.getSizeInventory() && !this.itemHandler.getStackInSlot(i).func_190926_b(); ++i) {
            ++amt;
        }
        if (amt > 0) {
            float anglePer = 360.0f / (float)amt;
            for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes.values()) {
                if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                RenderSystem.enableBlend();
                RenderSystem.enableRescaleNormal();
                RenderSystem.blendFunc((int)770, (int)771);
                float progress = (float)this.mana / (float)this.manaToGet;
                mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelper.drawTexturedModalRect(xc + radius + 9, yc - 8, 0.0f, progress == 1.0f ? 0 : 22, 8, 22, 15);
                if (progress == 1.0f) {
                    mc.func_175599_af().func_175042_a(new ItemStack((IItemProvider)ModBlocks.livingrock), xc + radius + 16, yc + 8);
                    RenderSystem.translatef((float)0.0f, (float)0.0f, (float)100.0f);
                    mc.func_175599_af().func_175042_a(new ItemStack((IItemProvider)ModItems.twigWand), xc + radius + 24, yc + 8);
                    RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-100.0f);
                }
                RenderHelper.renderProgressPie(xc + radius + 32, yc - 8, progress, recipe.getOutput());
                if (progress != 1.0f) continue;
                mc.field_71466_p.func_175063_a("+", (float)(xc + radius + 14), (float)(yc + 12), 0xFFFFFF);
            }
            for (int i = 0; i < amt; ++i) {
                double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                RenderSystem.translated((double)xPos, (double)yPos, (double)0.0);
                mc.func_175599_af().func_175042_a(this.itemHandler.getStackInSlot(i), 0, 0);
                RenderSystem.translated((double)(-xPos), (double)(-yPos), (double)0.0);
                angle += anglePer;
            }
        } else if (this.recipeKeepTicks > 0) {
            String s = I18n.func_135052_a((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 10), 0xFFFFFF);
            s = I18n.func_135052_a((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 20), 0xFFFFFF);
        }
    }

    public int getTargetMana() {
        return this.manaToGet;
    }
}

