/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;

@Mod.EventBusSubscriber(modid="botania")
public class SubTileNarslimmus
extends TileEntityGeneratingFlower {
    @ObjectHolder(value="botania:narslimmus")
    public static TileEntityType<SubTileNarslimmus> TYPE;
    public static final String TAG_WORLD_SPAWNED = "botania:world_spawned";
    private static final int RANGE = 2;

    public SubTileNarslimmus() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.ticksExisted % 5 == 0) {
            List slimes = this.func_145831_w().func_217357_a(SlimeEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-2, -2, -2), this.getEffectivePos().func_177982_a(3, 3, 3)));
            for (SlimeEntity slime : slimes) {
                if (!slime.getPersistentData().func_74767_n(TAG_WORLD_SPAWNED) || !slime.func_70089_S()) continue;
                int size = slime.func_70809_q();
                int mul = (int)Math.pow(2.0, size);
                int mana = 1200 * mul;
                if (!slime.field_70170_p.field_72995_K) {
                    slime.func_70106_y();
                    slime.func_184185_a(size > 1 ? SoundEvents.field_187886_fs : SoundEvents.field_187900_fz, 1.0f, 0.02f);
                    this.addMana(mana);
                    this.sync();
                }
                for (int j = 0; j < mul * 8; ++j) {
                    float f = slime.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                    float f1 = slime.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f;
                    float f2 = MathHelper.func_76126_a((float)f) * (float)size * 0.5f * f1;
                    float f3 = MathHelper.func_76134_b((float)f) * (float)size * 0.5f * f1;
                    float f4 = slime.field_70170_p.field_73012_v.nextFloat() * (float)size * 0.5f * f1;
                    slime.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, slime.func_226277_ct_() + (double)f2, slime.func_174813_aQ().field_72338_b + (double)f4, slime.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 2);
    }

    @Override
    public int getMaxMana() {
        return 12000;
    }

    @Override
    public int getColor() {
        return 7455603;
    }

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof SlimeEntity && event.getResult() != Event.Result.DENY && SubTileNarslimmus.isSlimeChunk(event.getEntityLiving().field_70170_p, event.getX(), event.getZ())) {
            event.getEntityLiving().getPersistentData().func_74757_a(TAG_WORLD_SPAWNED, true);
        }
    }

    private static boolean isSlimeChunk(World world, double x, double z) {
        return SubTileNarslimmus.isSlimeChunk(world, new BlockPos(x, 0.0, z));
    }

    public static boolean isSlimeChunk(World world, BlockPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos);
        return SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)world.func_72905_C(), (long)987234911L).nextInt(10) == 0;
    }
}

