/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;

public class BlockAltar
extends BlockMod {
    private static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape MIDDLE = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final VoxelShape TOP = Block.func_208617_a((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
    private static final VoxelShape TOP_CUTOUT = Block.func_208617_a((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)MIDDLE), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)TOP, (VoxelShape)TOP_CUTOUT, (IBooleanFunction)IBooleanFunction.field_223234_e_));
    public final Variant variant;

    protected BlockAltar(Variant v, Block.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileAltar tile;
        if (!world.field_72995_K && entity instanceof ItemEntity && (tile = (TileAltar)world.func_175625_s(pos)).collideEntityItem((ItemEntity)entity)) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
        }
    }

    public int getLightValue(@Nonnull BlockState state, IBlockReader world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAltar && ((TileAltar)te).getFluid() == Fluids.field_204547_b) {
            return 15;
        }
        return super.getLightValue(state, world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileAltar tile = (TileAltar)world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            InventoryHelper.withdrawFromInventory(tile, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            return ActionResultType.SUCCESS;
        }
        if (tile.isEmpty() && tile.getFluid() == Fluids.field_204546_a && stack.func_190926_b()) {
            tile.trySetLastRecipe(player);
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && (this.isValidWaterContainer(stack) || stack.func_77973_b() == ModItems.waterRod && ManaItemHandler.requestManaExact(stack, player, 75, false))) {
            if (tile.getFluid() == Fluids.field_204541_a) {
                if (stack.func_77973_b() == ModItems.waterRod) {
                    ManaItemHandler.requestManaExact(stack, player, 75, true);
                } else if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, this.drain((Fluid)Fluids.field_204546_a, stack));
                }
                tile.setFluid((Fluid)Fluids.field_204546_a);
                world.func_175666_e(pos, (Block)this);
                world.func_72863_F().func_212863_j_().func_215568_a(pos);
            }
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151129_at) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, this.drain((Fluid)Fluids.field_204547_b, stack));
            }
            tile.setFluid((Fluid)Fluids.field_204547_b);
            world.func_175666_e(pos, (Block)this);
            world.func_72863_F().func_212863_j_().func_215568_a(pos);
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151133_ar && tile.getFluid() != Fluids.field_204541_a && !Botania.gardenOfGlassLoaded) {
            ItemStack bucket = new ItemStack((IItemProvider)tile.getFluid().func_204524_b());
            if (stack.func_190916_E() == 1) {
                player.func_184611_a(hand, bucket);
            } else {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)bucket);
                stack.func_190918_g(1);
            }
            tile.setFluid(Fluids.field_204541_a);
            world.func_175666_e(pos, (Block)this);
            world.func_72863_F().func_212863_j_().func_215568_a(pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity tile;
        if (world.field_73012_v.nextInt(20) == 1 && (tile = world.func_175625_s(pos)) instanceof TileAltar) {
            TileAltar altar = (TileAltar)tile;
            if (altar.getFluid() == Fluids.field_204541_a) {
                altar.setFluid((Fluid)Fluids.field_204546_a);
            }
            world.func_175666_e(pos, (Block)this);
        }
    }

    private boolean isValidWaterContainer(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() != 1) {
            return false;
        }
        return (Boolean)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            FluidStack simulate = handler.drain(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.SIMULATE);
            return !simulate.isEmpty() && simulate.getFluid() == Fluids.field_204546_a && simulate.getAmount() == 1000;
        }).orElse((Object)false);
    }

    private ItemStack drain(Fluid fluid, ItemStack stack) {
        return (ItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            handler.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse((Object)stack);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileAltar();
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileAltar altar = (TileAltar)world.func_175625_s(pos);
        return altar.getFluid() == Fluids.field_204546_a ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY;

    }
}

