/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaGunTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = ResourceLocationHelper.prefix("fire_mana_blaster");
    public static final ManaGunTrigger INSTANCE = new ManaGunTrigger();
    private final Map<PlayerAdvancements, PlayerTracker> playerTrackers = new HashMap<PlayerAdvancements, PlayerTracker>();

    private ManaGunTrigger() {
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        this.playerTrackers.computeIfAbsent((PlayerAdvancements)player, (Function<PlayerAdvancements, PlayerTracker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.advancements.PlayerAdvancements ), (Lnet/minecraft/advancements/PlayerAdvancements;)Lvazkii/botania/common/advancements/ManaGunTrigger$PlayerTracker;)()).listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        PlayerTracker tracker = this.playerTrackers.get(player);
        if (tracker != null) {
            tracker.listeners.remove(listener);
            if (tracker.listeners.isEmpty()) {
                this.playerTrackers.remove(player);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements player) {
        this.playerTrackers.remove(player);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        Boolean desu = json.get("desu") == null ? null : Boolean.valueOf(json.get("desu").getAsBoolean());
        return new Instance(ItemPredicate.func_192492_a((JsonElement)json.get("item")), EntityPredicate.func_192481_a((JsonElement)json.get("user")), desu);
    }

    public void trigger(ServerPlayerEntity player, ItemStack stack) {
        PlayerTracker tracker = this.playerTrackers.get(player.func_192039_O());
        if (tracker != null) {
            tracker.trigger(player, stack);
        }
    }

    static class Instance
    implements ICriterionInstance {
        private final ItemPredicate item;
        private final EntityPredicate user;
        @Nullable
        private final Boolean desu;

        Instance(ItemPredicate count, EntityPredicate user, Boolean desu) {
            this.item = count;
            this.user = user;
            this.desu = desu;
        }

        @Nonnull
        public ResourceLocation func_192244_a() {
            return ID;
        }

        boolean test(ItemStack stack, ServerPlayerEntity entity) {
            return this.item.func_192493_a(stack) && this.user.func_192482_a(entity, (Entity)entity) && (this.desu == null || this.desu == ItemManaGun.isSugoiKawaiiDesuNe(stack));
        }
    }

    static class PlayerTracker {
        private final PlayerAdvancements playerAdvancements;
        final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        PlayerTracker(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public void trigger(ServerPlayerEntity player, ItemStack stack) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(stack, player)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }
}

