/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ILightReader;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.TileAltar;

public class RenderTileAltar
extends TileEntityRenderer<TileAltar> {
    public RenderTileAltar(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nonnull TileAltar altar, float pticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        boolean lava;
        if (!altar.func_145831_w().func_175667_e(altar.func_174877_v())) {
            return;
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 1.5, 0.5);
        boolean water = altar.getFluid() == Fluids.field_204546_a;
        boolean bl = lava = altar.getFluid() == Fluids.field_204547_b;
        if (water || lava) {
            ms.func_227860_a_();
            float s = 0.0390625f;
            float v = 0.125f;
            float w = -v * 2.5f;
            if (water) {
                int petals = 0;
                for (int i = 0; i < altar.getSizeInventory() && !altar.getItemHandler().getStackInSlot(i).func_190926_b(); ++i) {
                    ++petals;
                }
                if (petals > 0) {
                    float modifier = 6.0f;
                    float rotationModifier = 0.25f;
                    float radiusBase = 1.2f;
                    float radiusMod = 0.1f;
                    double ticks = (double)((float)ClientTickHandler.ticksInGame + pticks) * 0.5;
                    float offsetPerPetal = 360 / petals;
                    ms.func_227860_a_();
                    ms.func_227861_a_((double)-0.05f, -0.5, 0.0);
                    ms.func_227862_a_(v, v, v);
                    for (int i = 0; i < petals; ++i) {
                        float offset = offsetPerPetal * (float)i;
                        float deg = (int)(ticks / 0.25 % 360.0 + (double)offset);
                        float rad = deg * (float)Math.PI / 180.0f;
                        float radiusX = (float)((double)1.2f + (double)0.1f * Math.sin(ticks / 6.0));
                        float radiusZ = (float)((double)1.2f + (double)0.1f * Math.cos(ticks / 6.0));
                        float x = (float)((double)radiusX * Math.cos(rad));
                        float z = (float)((double)radiusZ * Math.sin(rad));
                        float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                        ms.func_227860_a_();
                        ms.func_227861_a_((double)x, (double)y, (double)z);
                        float xRotate = (float)Math.sin(ticks * 0.25) / 2.0f;
                        float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                        float zRotate = (float)Math.cos(ticks * 0.25) / 2.0f;
                        ms.func_227861_a_((double)(v /= 2.0f), (double)v, (double)v);
                        ms.func_227863_a_(new Vector3f(xRotate, yRotate, zRotate).func_229187_a_(deg));
                        ms.func_227861_a_((double)(-v), (double)(-v), (double)(-v));
                        v *= 2.0f;
                        ItemStack stack = altar.getItemHandler().getStackInSlot(i);
                        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, ms, buffers);
                        ms.func_227865_b_();
                    }
                    ms.func_227865_b_();
                }
            }
            float alpha = lava ? 1.0f : 0.7f;
            ms.func_227861_a_((double)w, (double)-0.3f, (double)w);
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227862_a_(s, s, s);
            TextureAtlasSprite sprite = lava ? Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150353_l.func_176223_P()).func_177554_e() : Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150355_j.func_176223_P()).func_177554_e();
            int color = lava ? Fluids.field_204547_b.getAttributes().getColor((ILightReader)altar.func_145831_w(), altar.func_174877_v()) : Fluids.field_204546_a.getAttributes().getColor((ILightReader)altar.func_145831_w(), altar.func_174877_v());
            IVertexBuilder buffer = buffers.getBuffer(Atlases.func_228784_i_());
            this.renderIcon(buffer, sprite, color, alpha, overlay, lava ? 0xF000F0 : light);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    private void renderIcon(IVertexBuilder builder, TextureAtlasSprite sprite, int color, float alpha, int overlay, int light) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        builder.func_225582_a_(0.0, 16.0, 0.0).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(16.0, 16.0, 0.0).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(16.0, 0.0, 0.0).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
    }
}

