/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.lwjgl.system.MemoryUtil;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lib.ResourceLocationHelper;

public final class ShaderHelper {
    public static final FloatBuffer FLOAT_BUF = MemoryUtil.memAllocFloat((int)1);
    private static final Map<BotaniaShader, ShaderProgram> PROGRAMS = new EnumMap<BotaniaShader, ShaderProgram>(BotaniaShader.class);
    private static boolean hasIncompatibleMods = false;
    private static boolean checkedIncompatibility = false;

    public static void initShaders() {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)manager -> {
                PROGRAMS.values().forEach(ShaderLinkHelper::func_148077_a);
                PROGRAMS.clear();
                ShaderHelper.loadShaders(manager);
            }));
        }
    }

    private static void loadShaders(IResourceManager manager) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        for (BotaniaShader shader : BotaniaShader.values()) {
            ShaderHelper.createProgram(manager, shader);
        }
    }

    public static OptionalInt getShader(BotaniaShader shader) {
        ShaderProgram prog = PROGRAMS.get((Object)shader);
        return prog == null ? OptionalInt.empty() : OptionalInt.of(prog.func_147986_h());
    }

    public static void useShader(BotaniaShader shader, ShaderCallback callback) {
        ShaderProgram prog = PROGRAMS.get((Object)shader);
        if (prog == null) {
            return;
        }
        ShaderHelper.useShader(prog.func_147986_h(), callback);
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        ShaderLinkHelper.func_227804_a_((int)shader);
        int time = GlStateManager.func_227680_b_((int)shader, (CharSequence)"time");
        GlStateManager.func_227718_f_((int)time, (int)ClientTickHandler.ticksInGame);
        if (callback != null) {
            callback.call(shader);
        }
    }

    public static void useShader(BotaniaShader shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderLinkHelper.func_227804_a_((int)0);
    }

    public static boolean useShaders() {
        return (Boolean)ConfigHandler.CLIENT.useShaders.get() != false && ShaderHelper.checkIncompatibleMods();
    }

    private static boolean checkIncompatibleMods() {
        if (!checkedIncompatibility) {
            hasIncompatibleMods = ModList.get().isLoaded("optifine");
            checkedIncompatibility = true;
        }
        return !hasIncompatibleMods;
    }

    private static void createProgram(IResourceManager manager, BotaniaShader shader) {
        try {
            ShaderLoader vert = ShaderHelper.createShader(manager, shader.vertexShaderPath, ShaderLoader.ShaderType.VERTEX);
            ShaderLoader frag = ShaderHelper.createShader(manager, shader.fragmentShaderPath, ShaderLoader.ShaderType.FRAGMENT);
            int progId = ShaderLinkHelper.func_148078_c();
            ShaderProgram prog = new ShaderProgram(progId, vert, frag);
            ShaderLinkHelper.func_148075_b((IShaderManager)prog);
            PROGRAMS.put(shader, prog);
        }
        catch (IOException ex) {
            Botania.LOGGER.error("Failed to load program {}", (Object)shader.name(), (Object)ex);
        }
    }

    private static ShaderLoader createShader(IResourceManager manager, String filename, ShaderLoader.ShaderType shaderType) throws IOException {
        ResourceLocation loc = ResourceLocationHelper.prefix(filename);
        try (BufferedInputStream is = new BufferedInputStream(manager.func_199002_a(loc).func_199027_b());){
            ShaderLoader shaderLoader = ShaderLoader.func_216534_a((ShaderLoader.ShaderType)shaderType, (String)loc.toString(), (InputStream)is);
            return shaderLoader;
        }
    }

    private static class ShaderProgram
    implements IShaderManager {
        private final int program;
        private final ShaderLoader vert;
        private final ShaderLoader frag;

        private ShaderProgram(int program, ShaderLoader vert, ShaderLoader frag) {
            this.program = program;
            this.vert = vert;
            this.frag = frag;
        }

        public int func_147986_h() {
            return this.program;
        }

        public void func_147985_d() {
        }

        public ShaderLoader func_147989_e() {
            return this.vert;
        }

        public ShaderLoader func_147994_f() {
            return this.frag;
        }
    }

    public static enum BotaniaShader {
        PYLON_GLOW("shader/passthrough.vert", "shader/pylon_glow.frag"),
        ENCHANTER_RUNE("shader/passthrough.vert", "shader/enchanter_rune.frag"),
        MANA_POOL("shader/passthrough.vert", "shader/mana_pool.frag"),
        DOPPLEGANGER("shader/doppleganger.vert", "shader/doppleganger.frag"),
        HALO("shader/passthrough.vert", "shader/halo.frag"),
        DOPPLEGANGER_BAR("shader/passthrough.vert", "shader/doppleganger_bar.frag"),
        TERRA_PLATE("shader/passthrough.vert", "shader/terra_plate_rune.frag"),
        FILM_GRAIN("shader/passthrough.vert", "shader/film_grain.frag"),
        GOLD("shader/passthrough.vert", "shader/gold.frag"),
        ALPHA("shader/passthrough.vert", "shader/alpha.frag");

        public final String vertexShaderPath;
        public final String fragmentShaderPath;

        private BotaniaShader(String vertexShaderPath, String fragmentShaderPath) {
            this.vertexShaderPath = vertexShaderPath;
            this.fragmentShaderPath = fragmentShaderPath;
        }
    }
}

