/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibObfuscation;
import vazkii.patchouli.client.book.gui.GuiBook;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public class RenderLexicon {
    private static final MethodHandle APPLY_EQUIP_OFFSET = LibObfuscation.getMethod(FirstPersonRenderer.class, "func_228406_b_", MatrixStack.class, HandSide.class, Float.TYPE);
    private static final MethodHandle APPLY_SWING_OFFSET = LibObfuscation.getMethod(FirstPersonRenderer.class, "func_228399_a_", MatrixStack.class, HandSide.class, Float.TYPE);
    private static final BookModel model = new BookModel();
    public static final Material TEXTURE = new Material(AtlasTexture.field_110575_b, new ResourceLocation("botania:model/lexicon_default"));
    public static final Material ELVEN_TEXTURE = new Material(AtlasTexture.field_110575_b, new ResourceLocation("botania:model/lexicon_elven"));
    private static final String[] QUOTES = new String[]{"\"Neat!\" - Direwolf20", "\"It's pretty ledge.\" - Haighyorkie", "\"I don't really like it.\" - CrustyMustard", "\"It's a very thinky mod.\" - AdamG3691", "\"You must craft the tiny potato.\" - TheFractangle", "\"Vazkii did a thing.\" - cpw"};
    private static int quote = -1;

    @SubscribeEvent
    public static void renderItem(RenderHandEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!((Boolean)ConfigHandler.CLIENT.lexicon3dModel.get()).booleanValue() || mc.field_71474_y.field_74320_O != 0 || mc.field_71439_g.func_184586_b(evt.getHand()).func_190926_b() || mc.field_71439_g.func_184586_b(evt.getHand()).func_77973_b() != ModItems.lexicon) {
            return;
        }
        evt.setCanceled(true);
        try {
            RenderLexicon.renderFirstPersonItem((AbstractClientPlayerEntity)mc.field_71439_g, evt.getPartialTicks(), evt.getInterpolatedPitch(), evt.getHand(), evt.getSwingProgress(), evt.getItemStack(), evt.getEquipProgress(), evt.getMatrixStack(), evt.getBuffers(), evt.getLight());
        }
        catch (Throwable throwable) {
            Botania.LOGGER.warn("Failed to render lexicon", throwable);
        }
    }

    private static void renderFirstPersonItem(AbstractClientPlayerEntity player, float partialTicks, float pitch, Hand hand, float swingProgress, ItemStack stack, float equipProgress, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        boolean flag = hand == Hand.MAIN_HAND;
        HandSide handside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        ms.func_227860_a_();
        boolean flag3 = handside == HandSide.RIGHT;
        float f5 = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        float f6 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
        float f10 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        int l = flag3 ? 1 : -1;
        ms.func_227861_a_((double)((float)l * f5), (double)f6, (double)f10);
        try {
            APPLY_EQUIP_OFFSET.invokeExact(Minecraft.func_71410_x().func_175597_ag(), ms, handside, equipProgress);
            APPLY_SWING_OFFSET.invokeExact(Minecraft.func_71410_x().func_175597_ag(), ms, handside, swingProgress);
        }
        catch (Throwable ex) {
            Botania.LOGGER.catching(ex);
        }
        RenderLexicon.doRender(stack, handside, ms, buffers, light, partialTicks);
        ms.func_227865_b_();
    }

    private static void doRender(ItemStack stack, HandSide side, MatrixStack ms, IRenderTypeBuffer buffers, int light, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ms.func_227860_a_();
        float ticks = ClientTickHandler.ticksWithLexicaOpen;
        if (ticks > 0.0f && ticks < 10.0f) {
            ticks = Minecraft.func_71410_x().field_71462_r instanceof GuiBook && ((GuiBook)Minecraft.func_71410_x().field_71462_r).book.getBookItem().func_77973_b() == ModItems.lexicon ? (ticks += partialTicks) : (ticks -= partialTicks);
        }
        if (side == HandSide.RIGHT) {
            ms.func_227861_a_((double)(0.3f + 0.02f * ticks), (double)(0.125f + 0.01f * ticks), (double)(-0.2f - 0.035f * ticks));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + ticks * 6.0f));
        } else {
            ms.func_227861_a_((double)(0.1f - 0.02f * ticks), (double)(0.125f + 0.01f * ticks), (double)(-0.2f - 0.035f * ticks));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(200.0f + ticks * 10.0f));
        }
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-0.3f + ticks * 2.85f));
        float opening = MathHelper.func_76131_a((float)(ticks / 12.0f), (float)0.0f, (float)1.0f);
        float pageFlipTicks = ClientTickHandler.pageFlipTicks;
        if (pageFlipTicks > 0.0f) {
            pageFlipTicks -= ClientTickHandler.partialTicks;
        }
        float pageFlip = pageFlipTicks / 5.0f;
        float leftPageAngle = MathHelper.func_226164_h_((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
        float rightPageAngle = MathHelper.func_226164_h_((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
        model.func_228247_a_(ClientTickHandler.total, MathHelper.func_76131_a((float)leftPageAngle, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)rightPageAngle, (float)0.0f, (float)1.0f), opening);
        Material mat = ((ItemLexicon)ModItems.lexicon).isElvenItem(stack) ? ELVEN_TEXTURE : TEXTURE;
        IVertexBuilder buffer = mat.func_229311_a_(buffers, RenderType::func_228634_a_);
        model.func_225598_a_(ms, buffer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (ticks < 3.0f) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            ms.func_227861_a_((double)-0.3f, (double)-0.24f, (double)-0.07f);
            ms.func_227862_a_(0.003f, 0.003f, -0.003f);
            String title = ItemLexicon.getTitle(stack).func_150254_d();
            font.func_228079_a_(font.func_78269_a(title, 80), 0.0f, 0.0f, 14063360, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
            ms.func_227861_a_(0.0, 10.0, 0.0);
            ms.func_227862_a_(0.6f, 0.6f, 0.6f);
            String edition = TextFormatting.ITALIC + "" + TextFormatting.BOLD + ItemLexicon.getEdition();
            font.func_228079_a_(edition, 0.0f, 0.0f, 10514688, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
            if (quote == -1) {
                quote = mc.field_71441_e.field_73012_v.nextInt(QUOTES.length);
            }
            String quoteStr = QUOTES[quote];
            ms.func_227861_a_(-5.0, 15.0, 0.0);
            RenderLexicon.renderText(0, 0, 140, 100, 0, 7995282, quoteStr, ms.func_227866_c_().func_227870_a_(), buffers, light);
            ms.func_227861_a_(8.0, 110.0, 0.0);
            String blurb = I18n.func_135052_a((String)"botaniamisc.lexiconcover0", (Object[])new Object[0]);
            font.func_228079_a_(blurb, 0.0f, 0.0f, 7995282, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
            ms.func_227861_a_(0.0, 10.0, 0.0);
            String blurb2 = TextFormatting.UNDERLINE + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"botaniamisc.lexiconcover1", (Object[])new Object[0]);
            font.func_228079_a_(blurb2, 0.0f, 0.0f, 7995282, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
            ms.func_227861_a_(0.0, -30.0, 0.0);
            String authorTitle = I18n.func_135052_a((String)"botaniamisc.lexiconcover2", (Object[])new Object[0]);
            int len = font.func_78256_a(authorTitle);
            font.func_228079_a_(authorTitle, 58.0f - (float)len / 2.0f, -8.0f, 14063360, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
        }
        ms.func_227865_b_();
    }

    /*
     * WARNING - void declaration
     */
    private static void renderText(int x, int y, int width, int height, int paragraphSize, int color, String unlocalizedText, Matrix4f matrix, IRenderTypeBuffer buffers, int light) {
        void var17_19;
        x += 2;
        y += 10;
        width -= 4;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String text = I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]).replaceAll("&", "\u00a7");
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        String[] stringArray = textEntries;
        int n = stringArray.length;
        boolean bl = false;
        while (var17_19 < n) {
            String[] tokens;
            String s = stringArray[var17_19];
            ArrayList<String> words = new ArrayList<String>();
            String lineStr = "";
            for (String token : tokens = s.split(" ")) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = lineStr + spaced;
                String controlCodes = RenderLexicon.toControlCodes(RenderLexicon.getControlCodes(prev));
                if (font.func_78256_a(lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add(controlCodes + token);
            }
            if (!lineStr.isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
            ++var17_19;
        }
        int i = 0;
        for (List list : lines) {
            boolean justify;
            int xi = x;
            int spacing = 4;
            int wcount = list.size();
            int compensationSpaces = 0;
            boolean bl2 = justify = (Boolean)ConfigHandler.CLIENT.lexiconJustifiedText.get() != false && wcount > 0 && lines.size() > i && !((List)lines.get(i + 1)).isEmpty();
            if (justify) {
                String s = Joiner.on((String)"").join((Iterable)list);
                int swidth = font.func_78256_a(s);
                int space = width - swidth;
                spacing = wcount == 1 ? 0 : space / (wcount - 1);
                compensationSpaces = wcount == 1 ? 0 : space % (wcount - 1);
            }
            for (String s : list) {
                int extra = 0;
                if (compensationSpaces > 0) {
                    --compensationSpaces;
                    ++extra;
                }
                font.func_228079_a_(s, (float)xi, (float)y, color, false, matrix, buffers, false, 0, light);
                xi += font.func_78256_a(s) + spacing + extra;
            }
            y += list.isEmpty() ? paragraphSize : 10;
            ++i;
        }
    }

    private static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        return controls.replaceAll(".*r", "r");
    }

    private static String toControlCodes(String s) {
        return s.replaceAll(".", "\u00a7$0");
    }
}

