/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.TilePlatform;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.item.Item16Colors;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.item.ItemManaMirror;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBloodPendant;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.material.ItemPetal;

public final class ColorHandler {
    public static void init() {
        BlockColors blocks = Minecraft.func_71410_x().func_184125_al();
        IBlockColor vineColor = (state, world, pos, tint) -> world != null && pos != null ? BiomeColors.func_228361_b_((ILightReader)world, (BlockPos)pos) : FoliageColors.func_77468_c();
        blocks.func_186722_a(vineColor, new Block[]{ModBlocks.solidVines});
        blocks.func_186722_a((state, world, pos, tintIndex) -> {
            TileEntity te;
            if (((BlockPool)state.func_177230_c()).variant == BlockPool.Variant.FABULOUS) {
                float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
                return MathHelper.func_181758_c((float)(time * 0.005f), (float)0.6f, (float)1.0f);
            }
            if (world != null && pos != null && (te = world.func_175625_s(pos)) instanceof TilePool) {
                return ((TilePool)te).color.field_193351_w;
            }
            return DyeColor.WHITE.field_193351_w;
        }, new Block[]{ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool});
        blocks.func_186722_a((state, world, pos, tintIndex) -> {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            return MathHelper.func_181758_c((float)(time * 5.0f % 360.0f / 360.0f), (float)0.4f, (float)0.9f);
        }, new Block[]{ModBlocks.gaiaSpreader});
        blocks.func_186722_a((state, world, pos, tintIndex) -> ((BlockPetalBlock)state.func_177230_c()).color.field_193351_w, new Block[]{ModBlocks.petalBlockWhite, ModBlocks.petalBlockOrange, ModBlocks.petalBlockMagenta, ModBlocks.petalBlockLightBlue, ModBlocks.petalBlockYellow, ModBlocks.petalBlockLime, ModBlocks.petalBlockPink, ModBlocks.petalBlockGray, ModBlocks.petalBlockSilver, ModBlocks.petalBlockCyan, ModBlocks.petalBlockPurple, ModBlocks.petalBlockBlue, ModBlocks.petalBlockBrown, ModBlocks.petalBlockGreen, ModBlocks.petalBlockRed, ModBlocks.petalBlockBlack});
        blocks.func_186722_a((state, world, pos, tintIndex) -> {
            TileEntity tile;
            if (world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof TilePlatform) {
                TilePlatform camo = (TilePlatform)tile;
                BlockState camoState = camo.camoState;
                if (camoState != null) {
                    return camoState.func_177230_c() instanceof BlockPlatform ? 0xFFFFFF : Minecraft.func_71410_x().func_184125_al().func_228054_a_(camoState, world, pos, tintIndex);
                }
            }
            return 0xFFFFFF;
        }, new Block[]{ModBlocks.abstrusePlatform, ModBlocks.spectralPlatform, ModBlocks.infrangiblePlatform});
        ItemColors items = Minecraft.func_71410_x().getItemColors();
        items.func_199877_a((s, t) -> MathHelper.func_181758_c((float)((float)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L) / 360.0f), (float)0.25f, (float)1.0f), new IItemProvider[]{ModItems.lifeEssence, ModItems.gaiaIngot});
        items.func_199877_a((s, t) -> t == 1 ? DyeColor.func_196056_a((int)ItemTwigWand.getColor1((ItemStack)s)).field_193351_w : (t == 2 ? DyeColor.func_196056_a((int)ItemTwigWand.getColor2((ItemStack)s)).field_193351_w : -1), new IItemProvider[]{ModItems.twigWand});
        IItemColor petalHandler = (s, t) -> ((ItemPetal)s.func_77973_b()).color.field_193351_w;
        IItemColor dyeHandler = (s, t) -> ((Item16Colors)s.func_77973_b()).color.field_193351_w;
        for (DyeColor color : DyeColor.values()) {
            items.func_199877_a(petalHandler, new IItemProvider[]{ModItems.getPetal(color)});
            items.func_199877_a(dyeHandler, new IItemProvider[]{ModItems.getDye(color)});
        }
        items.func_199877_a((s, t) -> Minecraft.func_71410_x().func_184125_al().func_228054_a_(((BlockItem)s.func_77973_b()).func_179223_d().func_176223_P(), null, null, t), new IItemProvider[]{ModBlocks.petalBlockWhite, ModBlocks.petalBlockOrange, ModBlocks.petalBlockMagenta, ModBlocks.petalBlockLightBlue, ModBlocks.petalBlockYellow, ModBlocks.petalBlockLime, ModBlocks.petalBlockPink, ModBlocks.petalBlockGray, ModBlocks.petalBlockSilver, ModBlocks.petalBlockCyan, ModBlocks.petalBlockPurple, ModBlocks.petalBlockBlue, ModBlocks.petalBlockBrown, ModBlocks.petalBlockGreen, ModBlocks.petalBlockRed, ModBlocks.petalBlockBlack, ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.gaiaSpreader});
        items.func_199877_a((s, t) -> t == 1 ? MathHelper.func_181758_c((float)0.528f, (float)((float)((ItemManaMirror)ModItems.manaMirror).getMana(s) / 1000000.0f), (float)1.0f) : -1, new IItemProvider[]{ModItems.manaMirror});
        items.func_199877_a((s, t) -> t == 1 ? MathHelper.func_181758_c((float)0.528f, (float)((float)((ItemManaTablet)ModItems.manaTablet).getMana(s) / 500000.0f), (float)1.0f) : -1, new IItemProvider[]{ModItems.manaTablet});
        items.func_199877_a((s, t) -> MathHelper.func_181758_c((float)0.55f, (float)(((float)s.func_77958_k() - (float)s.func_77952_i()) / (float)s.func_77958_k() * 0.5f), (float)1.0f), new IItemProvider[]{ModItems.spellCloth});
        items.func_199877_a((s, t) -> {
            if (t != 1) {
                return -1;
            }
            Brew brew = ((IBrewItem)s.func_77973_b()).getBrew(s);
            if (brew == BotaniaAPI.fallbackBrew) {
                return s.func_77973_b() instanceof ItemBloodPendant ? 12976142 : 0x989898;
            }
            int color = brew.getColor(s);
            double speed = s.func_77973_b() == ModItems.brewFlask || s.func_77973_b() == ModItems.brewVial ? 0.1 : 0.2;
            int add = (int)(Math.sin((double)ClientTickHandler.ticksInGame * speed) * 24.0);
            int r = Math.max(0, Math.min(255, (color >> 16 & 0xFF) + add));
            int g = Math.max(0, Math.min(255, (color >> 8 & 0xFF) + add));
            int b = Math.max(0, Math.min(255, (color & 0xFF) + add));
            return r << 16 | g << 8 | b;
        }, new IItemProvider[]{ModItems.bloodPendant, ModItems.incenseStick, ModItems.brewFlask, ModItems.brewVial});
        items.func_199877_a((s, t) -> {
            ItemStack lens = ItemManaGun.getLens(s);
            if (!lens.func_190926_b() && t == 0) {
                return Minecraft.func_71410_x().getItemColors().func_186728_a(lens, t);
            }
            if (t == 2) {
                BurstProperties props = ((ItemManaGun)s.func_77973_b()).getBurstProps((PlayerEntity)Minecraft.func_71410_x().field_71439_g, s, false, Hand.MAIN_HAND);
                float mul = (float)(Math.sin((double)ClientTickHandler.ticksInGame / 5.0) * (double)0.15f);
                int c = (int)(255.0f * mul);
                int r = (props.color >> 16 & 0xFF) + c;
                int g = (props.color >> 8 & 0xFF) + c;
                int b = (props.color & 0xFF) + c;
                int cr = MathHelper.func_76125_a((int)r, (int)0, (int)255);
                int cg = MathHelper.func_76125_a((int)g, (int)0, (int)255);
                int cb = MathHelper.func_76125_a((int)b, (int)0, (int)255);
                return cr << 16 | cg << 8 | cb;
            }
            return -1;
        }, new IItemProvider[]{ModItems.manaGun});
        items.func_199877_a((s, t) -> t == 1 ? MathHelper.func_181758_c((float)0.75f, (float)1.0f, (float)(1.5f - (float)Math.min(1.0, Math.sin((double)Util.func_211177_b() / 100.0) * 0.5 + (double)1.2f))) : -1, new IItemProvider[]{ModItems.enderDagger});
        items.func_199877_a((s, t) -> t == 1 && ItemTerraPick.isEnabled(s) ? MathHelper.func_181758_c((float)0.375f, (float)((float)Math.min(1.0, Math.sin((double)Util.func_211177_b() / 200.0) * 0.5 + 1.0)), (float)1.0f) : -1, new IItemProvider[]{ModItems.terraPick});
        dyeHandler = (s, t) -> t == 0 ? ((ItemLens)s.func_77973_b()).getLensColor(s) : -1;
        items.func_199877_a(dyeHandler, new IItemProvider[]{ModItems.lensNormal, ModItems.lensSpeed, ModItems.lensPower, ModItems.lensTime, ModItems.lensEfficiency, ModItems.lensBounce, ModItems.lensGravity, ModItems.lensMine, ModItems.lensDamage, ModItems.lensPhantom, ModItems.lensMagnet, ModItems.lensExplosive, ModItems.lensWeight, ModItems.lensPaint, ModItems.lensFire, ModItems.lensPiston, ModItems.lensLight, ModItems.lensWarp, ModItems.lensRedirect, ModItems.lensFirework, ModItems.lensFlare, ModItems.lensMessenger, ModItems.lensTripwire, ModItems.lensStorm});
    }

    private ColorHandler() {
    }
}

