/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;

public final class BaubleRenderHandler
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public BaubleRenderHandler(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
        super(renderer);
    }

    public void render(MatrixStack ms, IRenderTypeBuffer buffers, int light, @Nonnull AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.dispatchRenders(ms, buffers, light, (PlayerEntity)player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        if (((Boolean)ConfigHandler.CLIENT.renderAccessories.get()).booleanValue() && player.func_70660_b(Effects.field_76441_p) == null) {
            this.renderManaTablet(ms, buffers, (PlayerEntity)player);
        }
    }

    private void dispatchRenders(MatrixStack ms, IRenderTypeBuffer buffers, int light, PlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ms.func_227860_a_();
        CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            SortedMap curios = handler.getCurioMap();
            for (Map.Entry e : curios.entrySet()) {
                for (int i = 0; i < ((CurioStackHandler)e.getValue()).getSlots(); ++i) {
                    IPhantomInkable inkable;
                    Item item;
                    ItemStack stack = ((CurioStackHandler)e.getValue()).getStackInSlot(i);
                    if (stack.func_190926_b() || (item = stack.func_77973_b()) instanceof IPhantomInkable && (inkable = (IPhantomInkable)item).hasPhantomInk(stack) || !(item instanceof ICosmeticAttachable)) continue;
                    ICosmeticAttachable attachable = (ICosmeticAttachable)item;
                    ItemStack cosmetic = attachable.getCosmeticItem(stack);
                    cosmetic.getCapability(CuriosCapability.ITEM).ifPresent(c -> {
                        if (c.hasRender((String)e.getKey(), (LivingEntity)player)) {
                            ms.func_227860_a_();
                            c.render((String)e.getKey(), ms, buffers, light, (LivingEntity)player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                            ms.func_227865_b_();
                        }
                    });
                }
            }
        });
        ms.func_227865_b_();
    }

    private void renderManaTablet(MatrixStack ms, IRenderTypeBuffer buffers, PlayerEntity player) {
        boolean renderedOne = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.manaTablet) continue;
            ms.func_227860_a_();
            AccessoryRenderHelper.rotateIfSneaking(ms, (LivingEntity)player);
            boolean armor = !player.func_184582_a(EquipmentSlotType.LEGS).func_190926_b();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            ms.func_227861_a_(0.0, -0.6, 0.0);
            ms.func_227862_a_(0.55f, 0.55f, 0.55f);
            if (renderedOne) {
                ms.func_227861_a_(0.0, 0.0, armor ? (double)0.55f : 0.5);
            } else {
                ms.func_227861_a_(0.0, 0.0, armor ? (double)-0.55f : -0.5);
            }
            ms.func_227862_a_(0.75f, 0.75f, 0.75f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, 0xF000F0, OverlayTexture.field_229196_a_, ms, buffers);
            ms.func_227865_b_();
            if (renderedOne) {
                return;
            }
            renderedOne = true;
        }
    }
}

