/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.mana;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaDiscountEvent;
import vazkii.botania.api.mana.ManaItemsEvent;

public final class ManaItemHandler {
    public static List<ItemStack> getManaItems(PlayerEntity player) {
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(mainInv -> {
            int size = mainInv.getSlots();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stackInSlot = mainInv.getStackInSlot(slot);
                if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IManaItem)) continue;
                toReturn.add(stackInSlot);
            }
        });
        ManaItemsEvent event = new ManaItemsEvent(player, toReturn);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getItems();
    }

    public static List<ItemStack> getManaAccesories(PlayerEntity player) {
        if (player == null) {
            return Collections.emptyList();
        }
        IItemHandlerModifiable acc = BotaniaAPI.internalHandler.getAccessoriesInventory(player);
        if (acc == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>(acc.getSlots());
        for (int slot = 0; slot < acc.getSlots(); ++slot) {
            ItemStack stackInSlot = acc.getStackInSlot(slot);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IManaItem)) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    public static int requestMana(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        if (stack.func_190926_b()) {
            return 0;
        }
        List<ItemStack> items = ManaItemHandler.getManaItems(player);
        List<ItemStack> acc = ManaItemHandler.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            if (stackInSlot == stack || !(manaItem = (IManaItem)stackInSlot.func_77973_b()).canExportManaToItem(stackInSlot, stack) || manaItem.getMana(stackInSlot) <= 0 || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, stackInSlot)) continue;
            int mana = Math.min(manaToGet, manaItem.getMana(stackInSlot));
            if (remove) {
                manaItem.addMana(stackInSlot, -mana);
            }
            return mana;
        }
        return 0;
    }

    public static boolean requestManaExact(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        if (stack.func_190926_b()) {
            return false;
        }
        List<ItemStack> items = ManaItemHandler.getManaItems(player);
        List<ItemStack> acc = ManaItemHandler.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = (IManaItem)stackInSlot.func_77973_b()).canExportManaToItem(stackInSlot, stack) || manaItemSlot.getMana(stackInSlot) <= manaToGet || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, stackInSlot)) continue;
            if (remove) {
                manaItemSlot.addMana(stackInSlot, -manaToGet);
            }
            return true;
        }
        return false;
    }

    public static int dispatchMana(ItemStack stack, PlayerEntity player, int manaToSend, boolean add) {
        if (stack.func_190926_b()) {
            return 0;
        }
        List<ItemStack> items = ManaItemHandler.getManaItems(player);
        List<ItemStack> acc = ManaItemHandler.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = (IManaItem)stackInSlot.func_77973_b()).canReceiveManaFromItem(stackInSlot, stack) || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canExportManaToItem(stack, stackInSlot)) continue;
            int received = manaItemSlot.getMana(stackInSlot) + manaToSend <= manaItemSlot.getMaxMana(stackInSlot) ? manaToSend : manaToSend - (manaItemSlot.getMana(stackInSlot) + manaToSend - manaItemSlot.getMaxMana(stackInSlot));
            if (add) {
                manaItemSlot.addMana(stackInSlot, manaToSend);
            }
            return received;
        }
        return 0;
    }

    public static boolean dispatchManaExact(ItemStack stack, PlayerEntity player, int manaToSend, boolean add) {
        if (stack.func_190926_b()) {
            return false;
        }
        List<ItemStack> items = ManaItemHandler.getManaItems(player);
        List<ItemStack> acc = ManaItemHandler.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItemSlot;
            if (stackInSlot == stack || (manaItemSlot = (IManaItem)stackInSlot.func_77973_b()).getMana(stackInSlot) + manaToSend > manaItemSlot.getMaxMana(stackInSlot) || !manaItemSlot.canReceiveManaFromItem(stackInSlot, stack) || stack.func_77973_b() instanceof IManaItem && !((IManaItem)stack.func_77973_b()).canExportManaToItem(stack, stackInSlot)) continue;
            if (add) {
                manaItemSlot.addMana(stackInSlot, manaToSend);
            }
            return true;
        }
        return false;
    }

    public static int requestManaForTool(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        float multiplier = Math.max(0.0f, 1.0f - ManaItemHandler.getFullDiscountForTools(player, stack));
        int cost = (int)((float)manaToGet * multiplier);
        return (int)((float)ManaItemHandler.requestMana(stack, player, cost, remove) / multiplier);
    }

    public static boolean requestManaExactForTool(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        float multiplier = Math.max(0.0f, 1.0f - ManaItemHandler.getFullDiscountForTools(player, stack));
        int cost = (int)((float)manaToGet * multiplier);
        return ManaItemHandler.requestManaExact(stack, player, cost, remove);
    }

    public static float getFullDiscountForTools(PlayerEntity player, ItemStack tool) {
        float discount = 0.0f;
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (armor.func_190926_b() || !(armor.func_77973_b() instanceof IManaDiscountArmor)) continue;
            discount += ((IManaDiscountArmor)armor.func_77973_b()).getDiscount(armor, i, player, tool);
        }
        ManaDiscountEvent event = new ManaDiscountEvent(player, discount, tool);
        MinecraftForge.EVENT_BUS.post((Event)event);
        discount = event.getDiscount();
        return discount;
    }
}

