/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PickaxeItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelPick
extends PickaxeItem
implements IManaUsingItem,
ISortableTool {
    private static final Pattern TORCH_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)torch)|(?:(?:[a-z-_.:]|^)Torch))(?:[A-Z-_.:]|$)");
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelPick(Item.Properties props) {
        this(BotaniaAPI.MANASTEEL_ITEM_TIER, props, -2.8f);
    }

    public ItemManasteelPick(IItemTier mat, Item.Properties props, float attackSpeed) {
        super(mat, 1, attackSpeed, props);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible(stack, amount, entity, this.getManaPerDamage());
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        if (state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            ToolCommons.damageItem(stack, 1, entity, this.getManaPerDamage());
        }
        return true;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt = player.field_71071_by.func_70301_a(i);
                if (stackAt.func_190926_b() || !TORCH_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
                ItemStack displayStack = stackAt.func_77946_l();
                ActionResultType did = PlayerHelper.substituteUse(ctx, stackAt);
                ItemsRemainingRenderHandler.set(player, displayStack, TORCH_PATTERN);
                return did;
            }
        }
        return ActionResultType.PASS;
    }

    public int getManaPerDamage() {
        return 60;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof PlayerEntity && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (PlayerEntity)player, 120, true)) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ISortableTool.ToolType getSortingType(ItemStack stack) {
        return ISortableTool.ToolType.PICK;
    }

    @Override
    public int getSortingPriority(ItemStack stack) {
        return ToolCommons.getToolPriority(stack);
    }
}

