/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumPick;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

public final class ToolCommons {
    public static final List<Material> materialsPick = Arrays.asList(Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_215711_w);
    public static final List<Material> materialsShovel = Arrays.asList(Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B);
    public static final List<Material> materialsAxe = Arrays.asList(Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d, Material.field_151572_C);

    public static int damageItemIfPossible(ItemStack stack, int amount, LivingEntity entity, int manaPerDamage) {
        if (!(entity instanceof PlayerEntity)) {
            return amount;
        }
        PlayerEntity player = (PlayerEntity)entity;
        while (amount > 0 && ManaItemHandler.requestManaExactForTool(stack, player, manaPerDamage, true)) {
            --amount;
        }
        return amount;
    }

    public static void damageItem(ItemStack stack, int dmg, LivingEntity entity, int manaPerDamage) {
        boolean manaRequested;
        int manaToRequest = dmg * manaPerDamage;
        boolean bl = manaRequested = entity instanceof PlayerEntity && ManaItemHandler.requestManaExactForTool(stack, (PlayerEntity)entity, manaToRequest, true);
        if (!manaRequested) {
            stack.func_222118_a(dmg, entity, e -> {});
        }
    }

    public static void removeBlocksInIteration(PlayerEntity player, ItemStack stack, World world, BlockPos centerPos, Vec3i startDelta, Vec3i endDelta, Predicate<BlockState> filter, boolean dispose) {
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)centerPos.func_177971_a(startDelta), (BlockPos)centerPos.func_177971_a(endDelta))) {
            if (iterPos.equals((Object)centerPos)) continue;
            ToolCommons.removeBlockWithDrops(player, stack, world, iterPos, filter, dispose);
        }
    }

    public static void removeBlockWithDrops(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Predicate<BlockState> filter, boolean dispose) {
        ToolCommons.removeBlockWithDrops(player, stack, world, pos, filter, dispose, true);
    }

    public static void removeBlockWithDrops(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Predicate<BlockState> filter, boolean dispose, boolean particles) {
        if (!world.func_175667_e(pos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K && filter.test(state) && !block.isAir(state, (IBlockReader)world, pos) && state.func_185903_a(player, (IBlockReader)world, pos) > 0.0f && state.canHarvestBlock((IBlockReader)player.field_70170_p, pos, player)) {
            int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos);
            if (exp == -1) {
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                TileEntity tile = world.func_175625_s(pos);
                if (block.removedByPlayer(state, world, pos, player, true, world.func_204610_c(pos))) {
                    block.func_176206_d((IWorld)world, pos, state);
                    if (!dispose || !ItemElementiumPick.isDisposable(block)) {
                        block.func_180657_a(world, player, pos, state, tile, stack);
                        block.func_180637_b(world, pos, exp);
                    }
                }
                ToolCommons.damageItem(stack, 1, (LivingEntity)player, 80);
            } else {
                world.func_217377_a(pos, false);
            }
            if (particles && ((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue() && ((Boolean)ConfigHandler.COMMON.blockBreakParticlesTool.get()).booleanValue()) {
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            }
        }
    }

    public static int getToolPriority(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof ToolItem)) {
            return 0;
        }
        ToolItem tool = (ToolItem)item;
        IItemTier material = tool.func_200891_e();
        int materialLevel = 0;
        if (material == BotaniaAPI.MANASTEEL_ITEM_TIER) {
            materialLevel = 10;
        }
        if (material == BotaniaAPI.ELEMENTIUM_ITEM_TIER) {
            materialLevel = 11;
        }
        if (material == BotaniaAPI.TERRASTEEL_ITEM_TIER) {
            materialLevel = 20;
        }
        int modifier = 0;
        if (item == ModItems.terraPick) {
            modifier = ItemTerraPick.getLevel(stack);
        }
        int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        return materialLevel * 100 + modifier * 10 + efficiency;
    }

    public static BlockRayTraceResult raytraceFromEntity(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode, double range) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = range;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

