/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.advancements.ManaGunTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.ItemMod;

public class ItemManaGun
extends ItemMod
implements IManaUsingItem {
    private static final String TAG_LENS = "lens";
    private static final String TAG_CLIP = "clip";
    private static final String TAG_CLIP_POS = "clipPos";
    private static final int CLIP_SLOTS = 6;
    private static final int COOLDOWN = 30;

    public ItemManaGun(Item.Properties props) {
        super(props.func_200915_b(30));
    }

    public boolean func_185040_i() {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int effCd = 30;
        EffectInstance effect = player.func_70660_b(Effects.field_76422_e);
        if (effect != null) {
            effCd -= (effect.func_76458_c() + 1) * 8;
        }
        if (player.func_70093_af() && ItemManaGun.hasClip(stack)) {
            ItemManaGun.rotatePos(stack);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187839_fV, SoundCategory.PLAYERS, 0.6f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (world.field_72995_K) {
                player.func_184609_a(hand);
            }
            ItemStack lens = ItemManaGun.getLens(stack);
            ItemsRemainingRenderHandler.set(lens, -2);
            stack.func_196085_b(effCd);
            return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
        }
        if (stack.func_77952_i() == 0) {
            EntityManaBurst burst = this.getBurst(player, stack, true, hand);
            if (burst != null && ManaItemHandler.requestManaExact(stack, player, burst.getMana(), true)) {
                if (!world.field_72995_K) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.manaBlaster, SoundCategory.PLAYERS, 0.6f, 1.0f);
                    world.func_217376_c((Entity)burst);
                    ManaGunTrigger.INSTANCE.trigger((ServerPlayerEntity)player, stack);
                } else {
                    player.func_184609_a(hand);
                    player.func_213317_d(player.func_213322_ci().func_178788_d(burst.func_213322_ci().func_216372_d(0.1, 0.3, 0.1)));
                }
                stack.func_196085_b(effCd);
            } else if (!world.field_72995_K) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.6f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
            return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
    }

    public static boolean isSugoiKawaiiDesuNe(ItemStack stack) {
        return stack.func_200301_q().getString().equalsIgnoreCase("desu gun");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !ItemManaGun.getLens(stack).func_190926_b();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return ItemManaGun.getLens(itemStack);
    }

    @Nonnull
    public BurstProperties getBurstProps(PlayerEntity player, ItemStack stack, boolean request, Hand hand) {
        int maxMana = 120;
        int color = 0x20FF20;
        int ticksBeforeManaLoss = 60;
        float manaLossPerTick = 4.0f;
        float motionModifier = 5.0f;
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(maxMana, ticksBeforeManaLoss, manaLossPerTick, gravity, motionModifier, color);
        ItemStack lens = ItemManaGun.getLens(stack);
        if (!lens.func_190926_b()) {
            ((ILens)lens.func_77973_b()).apply(lens, props);
        }
        return props;
    }

    private EntityManaBurst getBurst(PlayerEntity player, ItemStack stack, boolean request, Hand hand) {
        EntityManaBurst burst = new EntityManaBurst(player);
        BurstProperties props = this.getBurstProps(player, stack, request, hand);
        burst.setSourceLens(ItemManaGun.getLens(stack));
        if (!request || ManaItemHandler.requestManaExact(stack, player, props.maxMana, false)) {
            burst.setColor(props.color);
            burst.setMana(props.maxMana);
            burst.setStartingMana(props.maxMana);
            burst.setMinManaLoss(props.ticksBeforeManaLoss);
            burst.setManaLossPerTick(props.manaLossPerTick);
            burst.setGravity(props.gravity);
            burst.setBurstMotion(burst.func_213322_ci().func_82615_a() * (double)props.motionModifier, burst.func_213322_ci().func_82617_b() * (double)props.motionModifier, burst.func_213322_ci().func_82616_c() * (double)props.motionModifier);
            return burst;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        List tooltip;
        boolean clip = ItemManaGun.hasClip(stack);
        if (clip && !Screen.hasShiftDown()) {
            stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.shiftinfo", new Object[0]));
            return;
        }
        ItemStack lens = ItemManaGun.getLens(stack);
        if (!lens.func_190926_b() && (tooltip = lens.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL)).size() > 1) {
            stacks.addAll(tooltip.subList(1, tooltip.size()));
        }
        if (clip) {
            int pos = ItemManaGun.getClipPos(stack);
            stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.hasClip", new Object[0]));
            for (int i = 0; i < 6; ++i) {
                ItemStack lensAt = ItemManaGun.getLensAtPos(stack, i);
                Object name = lensAt.func_190926_b() ? new TranslationTextComponent("botaniamisc.clipEmpty", new Object[0]) : lensAt.func_200301_q();
                ITextComponent tip = new StringTextComponent(" - ").func_150257_a(name);
                tip.func_150256_b().func_150238_a(i == pos ? TextFormatting.GREEN : TextFormatting.GRAY);
                stacks.add(tip);
            }
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        ItemStack lens = ItemManaGun.getLens(stack);
        ITextComponent cmp = super.func_200295_i(stack);
        if (!lens.func_190926_b()) {
            cmp.func_150258_a(" (");
            cmp.func_150257_a(lens.func_200301_q().func_211708_a(TextFormatting.GREEN));
            cmp.func_150258_a(")");
        }
        return cmp;
    }

    public static boolean hasClip(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CLIP, false);
    }

    public static void setClip(ItemStack stack, boolean clip) {
        ItemNBTHelper.setBoolean(stack, TAG_CLIP, clip);
    }

    public static int getClipPos(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_CLIP_POS, 0);
    }

    public static void setClipPos(ItemStack stack, int pos) {
        ItemNBTHelper.setInt(stack, TAG_CLIP_POS, pos);
    }

    public static void rotatePos(ItemStack stack) {
        int currPos = ItemManaGun.getClipPos(stack);
        boolean acceptEmpty = !ItemManaGun.getLensAtPos(stack, currPos).func_190926_b();
        int[] slots = new int[5];
        int index = 0;
        int i = currPos + 1;
        while (i < 6) {
            slots[index] = i++;
            ++index;
        }
        i = 0;
        while (i < currPos) {
            slots[index] = i++;
            ++index;
        }
        for (int i2 : slots) {
            ItemStack lensAt = ItemManaGun.getLensAtPos(stack, i2);
            if (!acceptEmpty && lensAt.func_190926_b()) continue;
            ItemManaGun.setClipPos(stack, i2);
            return;
        }
    }

    public static ItemStack getLensAtPos(ItemStack stack, int pos) {
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_LENS + pos, true);
        if (cmp != null) {
            return ItemStack.func_199557_a((CompoundNBT)cmp);
        }
        return ItemStack.field_190927_a;
    }

    public static void setLensAtPos(ItemStack stack, ItemStack lens, int pos) {
        CompoundNBT cmp = new CompoundNBT();
        if (lens != null) {
            cmp = lens.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS + pos, cmp);
    }

    public static void setLens(ItemStack stack, ItemStack lens) {
        if (ItemManaGun.hasClip(stack)) {
            ItemManaGun.setLensAtPos(stack, lens, ItemManaGun.getClipPos(stack));
        }
        CompoundNBT cmp = new CompoundNBT();
        if (!lens.func_190926_b()) {
            cmp = lens.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS, cmp);
    }

    public static ItemStack getLens(ItemStack stack) {
        if (ItemManaGun.hasClip(stack)) {
            return ItemManaGun.getLensAtPos(stack, ItemManaGun.getClipPos(stack));
        }
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_LENS, true);
        if (cmp != null) {
            return ItemStack.func_199557_a((CompoundNBT)cmp);
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getAllLens(ItemStack stack) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ret.add(ItemManaGun.getLensAtPos(stack, i));
        }
        return ret;
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean par5) {
        if (par1ItemStack.func_77951_h()) {
            par1ItemStack.func_196085_b(par1ItemStack.func_77952_i() - 1);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

