/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.IFloatingFlowerVariant;
import vazkii.botania.common.item.ItemMod;

@Mod.EventBusSubscriber(modid="botania")
public class ItemGrassSeeds
extends ItemMod
implements IFloatingFlowerVariant {
    private static final Map<DimensionType, Set<BlockSwapper>> blockSwappers = new HashMap<DimensionType, Set<BlockSwapper>>();
    private static final Map<IFloatingFlower.IslandType, float[]> COLORS = ImmutableMap.builder().put((Object)IFloatingFlower.IslandType.GRASS, (Object)new float[]{0.0f, 0.4f, 0.0f}).put((Object)IFloatingFlower.IslandType.PODZOL, (Object)new float[]{0.5f, 0.37f, 0.0f}).put((Object)IFloatingFlower.IslandType.MYCEL, (Object)new float[]{0.27f, 0.0f, 0.33f}).put((Object)IFloatingFlower.IslandType.DRY, (Object)new float[]{0.4f, 0.5f, 0.05f}).put((Object)IFloatingFlower.IslandType.GOLDEN, (Object)new float[]{0.75f, 0.7f, 0.0f}).put((Object)IFloatingFlower.IslandType.VIVID, (Object)new float[]{0.0f, 0.5f, 0.1f}).put((Object)IFloatingFlower.IslandType.SCORCHED, (Object)new float[]{0.75f, 0.0f, 0.0f}).put((Object)IFloatingFlower.IslandType.INFUSED, (Object)new float[]{0.0f, 0.55f, 0.55f}).put((Object)IFloatingFlower.IslandType.MUTATED, (Object)new float[]{0.4f, 0.1f, 0.4f}).build();
    private final IFloatingFlower.IslandType type;

    public ItemGrassSeeds(IFloatingFlower.IslandType type, Item.Properties props) {
        super(props);
        this.type = type;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        ItemStack stack = ctx.func_195996_i();
        if (state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_196658_i && this.type != IFloatingFlower.IslandType.GRASS) {
            if (!world.field_72995_K) {
                BlockSwapper swapper = ItemGrassSeeds.addBlockSwapper(world, pos, this.type);
                world.func_175656_a(pos, swapper.stateToSet);
                stack.func_190918_g(1);
            } else {
                float r = 0.0f;
                float g = 0.4f;
                float b = 0.0f;
                if (COLORS.containsKey(this.type)) {
                    float[] colors = COLORS.get(this.type);
                    r = colors[0];
                    g = colors[1];
                    b = colors[2];
                }
                for (int i = 0; i < 50; ++i) {
                    double x = (Math.random() - 0.5) * 3.0;
                    double y = Math.random() - 0.5 + 1.0;
                    double z = (Math.random() - 0.5) * 3.0;
                    float velMul = 0.025f;
                    float motionx = (float)(-x) * velMul;
                    float motiony = (float)(-y) * velMul;
                    float motionz = (float)(-z) * velMul;
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, r, g, b);
                    world.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + 0.5 + y, (double)pos.func_177952_p() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @SubscribeEvent
    public static void onTickEnd(TickEvent.WorldTickEvent event) {
        DimensionType dim;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.func_201675_m().func_186058_p())) {
            blockSwappers.get(dim).removeIf(next -> next == null || !next.tick());
        }
    }

    private static BlockSwapper addBlockSwapper(World world, BlockPos pos, IFloatingFlower.IslandType type) {
        BlockSwapper swapper = new BlockSwapper(world, pos, ItemGrassSeeds.stateForType(type));
        DimensionType dim = world.func_201675_m().func_186058_p();
        blockSwappers.computeIfAbsent(dim, d -> new HashSet()).add(swapper);
        return swapper;
    }

    private static BlockState stateForType(IFloatingFlower.IslandType type) {
        if (type == IFloatingFlower.IslandType.PODZOL) {
            return Blocks.field_196661_l.func_176223_P();
        }
        if (type == IFloatingFlower.IslandType.MYCEL) {
            return Blocks.field_150391_bh.func_176223_P();
        }
        if (type == IFloatingFlower.IslandType.DRY) {
            return ModBlocks.dryGrass.func_176223_P();
        }
        if (type == IFloatingFlower.IslandType.GOLDEN) {
            return ModBlocks.goldenGrass.func_176223_P();
        }
        if (type == IFloatingFlower.IslandType.VIVID) {
            return ModBlocks.vividGrass.func_176223_P();
        }
        if (type == IFloatingFlower.IslandType.SCORCHED) {
            return ModBlocks.scorchedGrass.func_176223_P();
        }
        if (type == IFloatingFlower.IslandType.INFUSED) {
            return ModBlocks.infusedGrass.func_176223_P();
        }
        if (type == IFloatingFlower.IslandType.MUTATED) {
            return ModBlocks.mutatedGrass.func_176223_P();
        }
        return Blocks.field_196658_i.func_176223_P();
    }

    @Override
    public IFloatingFlower.IslandType getIslandType(ItemStack stack) {
        return this.type;
    }

    private static class BlockSwapper {
        public static final int RANGE = 3;
        public static final int TICK_RANGE = 1;
        private final World world;
        private final Random rand;
        private final BlockState stateToSet;
        private final BlockPos startCoords;
        private int ticksExisted = 0;

        public BlockSwapper(World world, BlockPos coords, BlockState state) {
            this.world = world;
            this.stateToSet = state;
            this.rand = new Random(coords.hashCode());
            this.startCoords = coords;
        }

        public boolean tick() {
            if (++this.ticksExisted % 20 == 0) {
                for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.startCoords.func_177982_a(-3, 0, -3), (BlockPos)this.startCoords.func_177982_a(3, 0, 3))) {
                    if (this.world.func_180495_p(pos) != this.stateToSet) continue;
                    this.tickBlock(pos);
                }
            }
            return this.ticksExisted < 80;
        }

        public void tickBlock(BlockPos pos) {
            ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0 || !this.isValidSwapPosition(pos.func_177982_a(xOffset, 0, zOffset))) continue;
                    validCoords.add(pos.func_177982_a(xOffset, 0, zOffset));
                }
            }
            if (!validCoords.isEmpty()) {
                BlockPos toSwap = (BlockPos)validCoords.get(this.rand.nextInt(validCoords.size()));
                this.world.func_175656_a(toSwap, this.stateToSet);
            }
        }

        public boolean isValidSwapPosition(BlockPos pos) {
            BlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return (block == Blocks.field_150346_d || block == Blocks.field_196658_i) && this.world.func_180495_p(pos.func_177984_a()).func_200016_a((IBlockReader)this.world, pos.func_177984_a()) <= 1;
        }
    }
}

