/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class InventoryHelper {
    public static InvWithLocation getInventoryWithLocation(World world, BlockPos pos, Direction side) {
        IItemHandler ret = InventoryHelper.getInventory(world, pos, side);
        if (ret == null) {
            return null;
        }
        return new InvWithLocation(ret, world, pos);
    }

    public static IItemHandler getInventory(World world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        LazyOptional ret = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (!ret.isPresent()) {
            ret = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return (IItemHandler)ret.orElse(null);
    }

    public static void dropInventory(TileSimpleInventory inv, World world, BlockState state, BlockPos pos) {
        if (inv != null) {
            for (int j1 = 0; j1 < inv.getSizeInventory(); ++j1) {
                ItemStack itemstack = inv.getItemHandler().getStackInSlot(j1);
                if (itemstack.func_190926_b()) continue;
                net.minecraft.inventory.InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
            }
            world.func_175666_e(pos, state.func_177230_c());
        }
    }

    public static void withdrawFromInventory(TileSimpleInventory inv, PlayerEntity player) {
        for (int i = inv.getSizeInventory() - 1; i >= 0; --i) {
            ItemStack stackAt = inv.getItemHandler().getStackInSlot(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack copy = stackAt.func_77946_l();
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)copy);
            inv.getItemHandler().setStackInSlot(i, ItemStack.field_190927_a);
            player.field_70170_p.func_175666_e(inv.func_174877_v(), null);
            break;
        }
    }
}

