/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IManaDissolvable;
import vazkii.botania.api.mana.IKeyLocked;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IThrottledPacket;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileBellows;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ModItems;

public class TilePool
extends TileMod
implements IManaPool,
IKeyLocked,
ISparkAttachable,
IThrottledPacket,
ITickableTileEntity {
    @ObjectHolder(value="botania:mana_pool")
    public static TileEntityType<TilePool> TYPE;
    public static final Color PARTICLE_COLOR;
    public static final int MAX_MANA = 1000000;
    private static final int MAX_MANA_DILLUTED = 10000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_KNOWN_MANA = "knownMana";
    private static final String TAG_OUTPUTTING = "outputting";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA_CAP = "manaCap";
    private static final String TAG_CAN_ACCEPT = "canAccept";
    private static final String TAG_CAN_SPARE = "canSpare";
    private static final String TAG_FRAGILE = "fragile";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    private boolean outputting = false;
    public DyeColor color = DyeColor.WHITE;
    private int mana;
    private int knownMana = -1;
    public int manaCap = -1;
    private int soundTicks = 0;
    private boolean canAccept = true;
    private boolean canSpare = true;
    public boolean fragile = false;
    boolean isDoingTransfer = false;
    int ticksDoingTransfer = 0;
    private String inputKey = "";
    private final String outputKey = "";
    private int ticks = 0;
    private boolean sendPacket = false;

    public TilePool() {
        super(TYPE);
    }

    @Override
    public boolean isFull() {
        Block blockBelow = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c();
        return blockBelow != ModBlocks.manaVoid && this.getCurrentMana() >= this.manaCap;
    }

    @Override
    public void recieveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.manaCap));
        if (old != this.mana) {
            this.func_70296_d();
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            this.markDispatchable();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        ManaNetworkEvent.removePool(this);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ManaNetworkEvent.removePool(this);
    }

    public static int calculateComparatorLevel(int mana, int max) {
        int val = (int)((double)mana / (double)max * 15.0);
        if (mana > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    public static RecipeManaInfusion getMatchingRecipe(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        ArrayList<RecipeManaInfusion> matchingNonCatRecipes = new ArrayList<RecipeManaInfusion>();
        ArrayList<RecipeManaInfusion> matchingCatRecipes = new ArrayList<RecipeManaInfusion>();
        for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes.values()) {
            if (!recipe.matches(stack)) continue;
            if (recipe.getCatalyst() == null) {
                matchingNonCatRecipes.add(recipe);
                continue;
            }
            if (recipe.getCatalyst() != state) continue;
            matchingCatRecipes.add(recipe);
        }
        return !matchingCatRecipes.isEmpty() ? (RecipeManaInfusion)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (RecipeManaInfusion)matchingNonCatRecipes.get(0) : null);
    }

    public boolean collideEntityItem(ItemEntity item) {
        if (this.field_145850_b.field_72995_K || !item.func_70089_S() || item.func_92059_d().func_190926_b()) {
            return false;
        }
        ItemStack stack = item.func_92059_d();
        if (stack.func_77973_b() instanceof IManaDissolvable) {
            ((IManaDissolvable)stack.func_77973_b()).onDissolveTick(this, stack, item);
        }
        if (item.field_70292_b > 100 && item.field_70292_b < 130) {
            return false;
        }
        RecipeManaInfusion recipe = TilePool.getMatchingRecipe(stack, this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.recieveMana(-mana);
                stack.func_190918_g(1);
                item.field_70122_E = false;
                ItemStack output = recipe.getOutput().func_77946_l();
                ItemEntity outputItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                outputItem.field_70292_b = 105;
                this.field_145850_b.func_217376_c((Entity)outputItem);
                this.craftingFanciness();
                return true;
            }
        }
        return false;
    }

    private void craftingFanciness() {
        if (this.soundTicks == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.manaPoolCraft, SoundCategory.BLOCKS, 0.4f, 4.0f);
            this.soundTicks = 6;
        }
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
    }

    public boolean func_145842_c(int event, int param) {
        switch (event) {
            case 0: {
                if (this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
            case 1: {
                if (this.field_145850_b.field_72995_K && ((Boolean)ConfigHandler.COMMON.chargingAnimationEnabled.get()).booleanValue()) {
                    boolean outputting = param == 1;
                    Vector3 itemVec = Vector3.fromBlockPos(this.field_174879_c).add(0.5, 0.5 + Math.random() * 0.3, 0.5);
                    Vector3 tileVec = Vector3.fromBlockPos(this.field_174879_c).add(0.2 + Math.random() * 0.6, 0.0, 0.2 + Math.random() * 0.6);
                    Botania.proxy.lightningFX(outputting ? tileVec : itemVec, outputting ? itemVec : tileVec, 80.0f, this.field_145850_b.field_73012_v.nextLong(), 1140881820, 1140901631);
                }
                return true;
            }
        }
        return super.func_145842_c(event, param);
    }

    public void func_73660_a() {
        if (this.manaCap == -1) {
            int n = this.manaCap = ((BlockPool)this.func_195044_w().func_177230_c()).variant == BlockPool.Variant.DILUTED ? 10000 : 1000000;
        }
        if (!ManaNetworkHandler.instance.isPoolIn(this) && !this.func_145837_r()) {
            ManaNetworkEvent.addPool(this);
        }
        if (this.field_145850_b.field_72995_K) {
            double particleChance = 1.0 - (double)this.getCurrentMana() / (double)this.manaCap * 0.1;
            if (Math.random() > particleChance) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, (float)PARTICLE_COLOR.getRed() / 255.0f, (float)PARTICLE_COLOR.getGreen() / 255.0f, (float)PARTICLE_COLOR.getBlue() / 255.0f, 2.0f);
                this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.3 + Math.random() * 0.5, (double)this.field_174879_c.func_177956_o() + 0.6 + Math.random() * 0.25, (double)this.field_174879_c.func_177952_p() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
            }
            return;
        }
        boolean wasDoingTransfer = this.isDoingTransfer;
        this.isDoingTransfer = false;
        if (this.soundTicks > 0) {
            --this.soundTicks;
        }
        if (this.sendPacket && this.ticks % 10 == 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.sendPacket = false;
        }
        List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
        for (ItemEntity item : items) {
            int manaVal;
            ItemStack stack;
            if (!item.func_70089_S() || (stack = item.func_92059_d()).func_190926_b() || !(stack.func_77973_b() instanceof IManaItem)) continue;
            IManaItem mana = (IManaItem)stack.func_77973_b();
            if ((!this.outputting || !mana.canReceiveManaFromPool(stack, this)) && (this.outputting || !mana.canExportManaToPool(stack, this))) continue;
            boolean didSomething = false;
            int bellowCount = 0;
            if (this.outputting) {
                for (Direction dir : MathHelper.HORIZONTALS) {
                    TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
                    if (!(tile instanceof TileBellows) || ((TileBellows)tile).getLinkedTile() != this) continue;
                    ++bellowCount;
                }
            }
            int transfRate = 1000 * (bellowCount + 1);
            if (this.outputting) {
                if (this.canSpare) {
                    if (this.getCurrentMana() > 0 && mana.getMana(stack) < mana.getMaxMana(stack)) {
                        didSomething = true;
                    }
                    manaVal = Math.min(transfRate, Math.min(this.getCurrentMana(), mana.getMaxMana(stack) - mana.getMana(stack)));
                    mana.addMana(stack, manaVal);
                    this.recieveMana(-manaVal);
                }
            } else if (this.canAccept) {
                if (mana.getMana(stack) > 0 && !this.isFull()) {
                    didSomething = true;
                }
                manaVal = Math.min(transfRate, Math.min(this.manaCap - this.getCurrentMana(), mana.getMana(stack)));
                mana.addMana(stack, -manaVal);
                this.recieveMana(manaVal);
            }
            if (!didSomething) continue;
            if (((Boolean)ConfigHandler.COMMON.chargingAnimationEnabled.get()).booleanValue() && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.outputting ? 1 : 0);
            }
            this.isDoingTransfer = this.outputting;
        }
        if (this.isDoingTransfer) {
            ++this.ticksDoingTransfer;
        } else {
            this.ticksDoingTransfer = 0;
            if (wasDoingTransfer) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
        ++this.ticks;
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74757_a(TAG_OUTPUTTING, this.outputting);
        cmp.func_74768_a(TAG_COLOR, this.color.func_196059_a());
        cmp.func_74768_a(TAG_MANA_CAP, this.manaCap);
        cmp.func_74757_a(TAG_CAN_ACCEPT, this.canAccept);
        cmp.func_74757_a(TAG_CAN_SPARE, this.canSpare);
        cmp.func_74757_a(TAG_FRAGILE, this.fragile);
        cmp.func_74778_a(TAG_INPUT_KEY, this.inputKey);
        cmp.func_74778_a(TAG_OUTPUT_KEY, "");
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.outputting = cmp.func_74767_n(TAG_OUTPUTTING);
        this.color = DyeColor.func_196056_a((int)cmp.func_74762_e(TAG_COLOR));
        if (cmp.func_74764_b(TAG_MANA_CAP)) {
            this.manaCap = cmp.func_74762_e(TAG_MANA_CAP);
        }
        if (cmp.func_74764_b(TAG_CAN_ACCEPT)) {
            this.canAccept = cmp.func_74767_n(TAG_CAN_ACCEPT);
        }
        if (cmp.func_74764_b(TAG_CAN_SPARE)) {
            this.canSpare = cmp.func_74767_n(TAG_CAN_SPARE);
        }
        this.fragile = cmp.func_74767_n(TAG_FRAGILE);
        if (cmp.func_74764_b(TAG_INPUT_KEY)) {
            this.inputKey = cmp.func_74779_i(TAG_INPUT_KEY);
        }
        if (cmp.func_74764_b(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.func_74779_i(TAG_OUTPUT_KEY);
        }
        if (cmp.func_74764_b(TAG_KNOWN_MANA)) {
            this.knownMana = cmp.func_74762_e(TAG_KNOWN_MANA);
        }
    }

    public void onWanded(PlayerEntity player, ItemStack wand) {
        if (player == null) {
            return;
        }
        if (player.func_70093_af()) {
            this.outputting = !this.outputting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            this.writePacketNBT(nbttagcompound);
            nbttagcompound.func_74768_a(TAG_KNOWN_MANA, this.getCurrentMana());
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SUpdateTileEntityPacket(this.field_174879_c, -999, nbttagcompound));
            }
        }
        this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.ding, SoundCategory.PLAYERS, 0.11f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc) {
        ItemStack pool = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c());
        String name = pool.func_200301_q().getString();
        int color = 0x4444FF;
        HUDHandler.drawSimpleManaHUD(color, this.knownMana, this.manaCap, name);
        int x = Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 - 11;
        int y = Minecraft.func_71410_x().field_195558_d.func_198087_p() / 2 + 30;
        int u = this.outputting ? 22 : 0;
        int v = 38;
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, u, v, 22, 15);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tablet = new ItemStack((IItemProvider)ModItems.manaTablet);
        ItemManaTablet.setStackCreative(tablet);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        mc.func_175599_af().func_180450_b(tablet, x - 20, y);
        mc.func_175599_af().func_180450_b(pool, x + 26, y);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public int getCurrentMana() {
        if (this.func_195044_w().func_177230_c() instanceof BlockPool) {
            return ((BlockPool)this.func_195044_w().func_177230_c()).variant == BlockPool.Variant.CREATIVE ? 1000000 : this.mana;
        }
        return 0;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public void attachSpark(ISparkEntity entity) {
    }

    @Override
    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int getAvailableSpaceForMana() {
        int space = Math.max(0, this.manaCap - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.manaVoid) {
            return this.manaCap;
        }
        return 0;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(DyeColor color) {
        this.color = color;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Override
    public void markDispatchable() {
        this.sendPacket = true;
    }

    static {
        PARTICLE_COLOR = new Color(50943);
    }
}

