/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.material.ItemDye;

public class BlockSpecialFlower
extends FlowerBlock
implements IWandable,
IWandHUD {
    private static final VoxelShape SHAPE = BlockSpecialFlower.func_208617_a((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    private final Supplier<? extends TileEntitySpecialFlower> teProvider;

    protected BlockSpecialFlower(Block.Properties props, Supplier<? extends TileEntitySpecialFlower> teProvider) {
        super(Effects.field_76424_c, 4, props);
        this.teProvider = teProvider;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, ISelectionContext ctx) {
        Vec3d shift = state.func_191059_e(world, pos);
        return SHAPE.func_197751_a(shift.field_72450_a, shift.field_72448_b, shift.field_72449_c);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return ((TileEntitySpecialFlower)world.func_175625_s(pos)).getComparatorInputOverride();
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return ((TileEntitySpecialFlower)world.func_175625_s(pos)).getPowerLevel(side);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == ModBlocks.redStringRelay || state.func_177230_c() == Blocks.field_150391_bh || super.func_200014_a_(state, worldIn, pos);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        ((TileEntitySpecialFlower)world.func_175625_s(pos)).onBlockHarvested(world, pos, state, player);
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof TileEntitySpecialFlower) {
            return ((TileEntitySpecialFlower)te).getDrops(drops, builder);
        }
        return drops;
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int par5, int par6) {
        super.func_189539_a(state, world, pos, par5, par6);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(par5, par6);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return this.teProvider.get();
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        return ((TileEntitySpecialFlower)world.func_175625_s(pos)).onWanded(player, stack);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        ((TileEntitySpecialFlower)world.func_175625_s(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        ((TileEntitySpecialFlower)world.func_175625_s(pos)).onBlockAdded(world, pos, state);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemDye) {
            DyeColor newColor = ((ItemDye)stack.func_77973_b()).color;
            DyeColor oldColor = (DyeColor)state.func_177229_b(BotaniaStateProps.COLOR);
            if (newColor != oldColor) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a(BotaniaStateProps.COLOR, (Comparable)newColor), 3);
            }
            return true;
        }
        return ((TileEntitySpecialFlower)world.func_175625_s(pos)).onBlockActivated(world, pos, state, player, hand, hit);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        ((TileEntitySpecialFlower)world.func_175625_s(pos)).renderHUD(mc);
    }
}

