/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import vazkii.botania.api.mana.IPoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.mana.TilePool;

public class RenderTilePool
extends TileEntityRenderer<TilePool> {
    public static int cartMana = -1;

    public void render(@Nullable TilePool pool, double d0, double d1, double d2, float f, int digProgress) {
        TextureAtlasSprite overlay;
        Block below;
        int cap;
        if (!(pool == null || pool.func_145831_w().func_175667_e(pool.func_174877_v()) && pool.func_195044_w().func_177230_c() instanceof BlockPool)) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pool == null) {
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
        } else {
            GlStateManager.translated((double)d0, (double)d1, (double)d2);
        }
        boolean fab = pool != null && ((BlockPool)pool.func_195044_w().func_177230_c()).variant == BlockPool.Variant.FABULOUS;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        if (fab) {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            int color = Color.HSBtoRGB((time += (float)new Random(pool.func_174877_v().func_177958_n() ^ pool.func_174877_v().func_177956_o() ^ pool.func_174877_v().func_177952_p()).nextInt(100000)) * 0.005f, 0.6f, 1.0f);
            int red = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int blue = color & 0xFF;
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(pool.func_145831_w().func_180495_p(pool.func_174877_v()));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(model, 1.0f, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
        }
        GlStateManager.translatef((float)0.5f, (float)1.5f, (float)0.5f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        int mana = pool == null ? cartMana : pool.getCurrentMana();
        int n = cap = pool == null ? -1 : pool.manaCap;
        if (cap == -1) {
            cap = 1000000;
        }
        float waterLevel = (float)mana / (float)cap * 0.4f;
        float s = 0.0625f;
        float v = 0.125f;
        float w = -v * 3.5f;
        if (pool != null && (below = pool.func_145831_w().func_180495_p(pool.func_174877_v().func_177977_b()).func_177230_c()) instanceof IPoolOverlayProvider && (overlay = ((IPoolOverlayProvider)below).getIcon(pool.func_145831_w(), pool.func_174877_v())) != null) {
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.disableAlphaTest();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f * (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2)));
            GlStateManager.translatef((float)-0.5f, (float)-1.4300001f, (float)-0.5f);
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)s, (float)s, (float)s);
            this.renderIcon(0, 0, overlay, 16, 16, 240);
            GlStateManager.enableAlphaTest();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
        if (waterLevel > 0.0f) {
            s = 0.0546875f;
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.disableAlphaTest();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.translatef((float)w, (float)(-1.0f - (0.43f - waterLevel)), (float)w);
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)s, (float)s, (float)s);
            ShaderHelper.useShader(ShaderHelper.manaPool);
            this.renderIcon(0, 0, MiscellaneousIcons.INSTANCE.manaWater, 16, 16, 240);
            ShaderHelper.releaseShader();
            GlStateManager.enableAlphaTest();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
        cartMana = -1;
    }

    private void renderIcon(int par1, int par2, TextureAtlasSprite par3Icon, int par4, int par5, int brightness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, ClientProxy.POSITION_TEX_LMAP);
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_78381_a();
    }

    private BlockState poolForVariant(BlockPool.Variant v) {
        switch (v) {
            default: {
                return ModBlocks.manaPool.func_176223_P();
            }
            case CREATIVE: {
                return ModBlocks.creativePool.func_176223_P();
            }
            case DILUTED: {
                return ModBlocks.dilutedPool.func_176223_P();
            }
            case FABULOUS: 
        }
        return ModBlocks.fabulousPool.func_176223_P();
    }
}

