/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.tile.TileEnchanter;

public class RenderTileEnchanter
extends TileEntityRenderer<TileEnchanter> {
    private ItemEntity item;

    public void render(@Nonnull TileEnchanter enchanter, double d0, double d1, double d2, float f, int digProgress) {
        float alphaMod = 0.0f;
        if (enchanter.stage == TileEnchanter.State.GATHER_MANA) {
            alphaMod = (float)Math.min(20, enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == TileEnchanter.State.RESET) {
            alphaMod = (float)(20 - enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == TileEnchanter.State.DO_ENCHANT) {
            alphaMod = 1.0f;
        }
        if (!enchanter.itemToEnchant.func_190926_b()) {
            if (this.item == null) {
                this.item = new ItemEntity(enchanter.func_145831_w(), (double)enchanter.func_174877_v().func_177958_n(), (double)(enchanter.func_174877_v().func_177956_o() + 1), (double)enchanter.func_174877_v().func_177952_p(), enchanter.itemToEnchant);
            }
            this.item.field_70292_b = ClientTickHandler.ticksInGame;
            this.item.func_92058_a(enchanter.itemToEnchant);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.translatef((float)0.5f, (float)1.25f, (float)0.5f);
            ((EntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(ItemEntity.class)).func_76986_a((Entity)this.item, d0, d1, d2, 1.0f, f);
            GlStateManager.translatef((float)-0.5f, (float)-1.25f, (float)-0.5f);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)d0, (double)d1, (double)d2);
        GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)-2.0f, (float)-2.0f, (float)-0.001f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableAlphaTest();
        float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 8.0) + 1.0) / 5.0 + 0.4) * alphaMod;
        if (alpha > 0.0f) {
            if (ShaderHelper.useShaders()) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            } else {
                int light = 0xF000F0;
                int lightmapX = light % 65536;
                int lightmapY = light / 65536;
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
                GlStateManager.color4f((float)(0.6f + (float)((Math.cos((double)((float)ClientTickHandler.ticksInGame + f) / 6.0) + 1.0) / 5.0)), (float)0.1f, (float)0.9f, (float)alpha);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            if (enchanter.stage == TileEnchanter.State.DO_ENCHANT || enchanter.stage == TileEnchanter.State.RESET) {
                int ticks = enchanter.stageTicks + enchanter.stage3EndTicks;
                int angle = ticks * 2;
                float yTranslation = (float)Math.min(20, ticks) / 20.0f * 1.15f;
                float scale = ticks < 10 ? 1.0f : 1.0f - (float)Math.min(20, ticks - 10) / 20.0f * 0.75f;
                GlStateManager.translatef((float)2.5f, (float)2.5f, (float)(-yTranslation));
                GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
                GlStateManager.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.translatef((float)-2.5f, (float)-2.5f, (float)0.0f);
            }
            ShaderHelper.useShader(ShaderHelper.enchanterRune);
            this.renderIcon(0, 0, MiscellaneousIcons.INSTANCE.enchanterOverlay, 5, 5, 240);
            ShaderHelper.releaseShader();
        }
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    private void renderIcon(int par1, int par2, TextureAtlasSprite par3Icon, int par4, int par5, int brightness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, ClientProxy.POSITION_TEX_LMAP);
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g()).func_187314_a(brightness, brightness).func_181675_d();
        tessellator.func_78381_a();
    }
}

