/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IEnviromentBlockReader;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.TileAltar;

public class RenderTileAltar
extends TileEntityRenderer<TileAltar> {
    public void render(@Nonnull TileAltar altar, double d0, double d1, double d2, float pticks, int digProgress) {
        boolean lava;
        if (!altar.func_145831_w().func_175667_e(altar.func_174877_v())) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)(d0 + 0.5), (double)(d1 + 1.5), (double)(d2 + 0.5));
        GlStateManager.enableRescaleNormal();
        boolean water = altar.getFluid() == Fluids.field_204546_a;
        boolean bl = lava = altar.getFluid() == Fluids.field_204547_b;
        if (water || lava) {
            GlStateManager.pushMatrix();
            float s = 0.0390625f;
            float v = 0.125f;
            float w = -v * 2.5f;
            if (water) {
                int petals = 0;
                for (int i = 0; i < altar.getSizeInventory() && !altar.getItemHandler().getStackInSlot(i).func_190926_b(); ++i) {
                    ++petals;
                }
                if (petals > 0) {
                    float modifier = 6.0f;
                    float rotationModifier = 0.25f;
                    float radiusBase = 1.2f;
                    float radiusMod = 0.1f;
                    double ticks = (double)((float)ClientTickHandler.ticksInGame + pticks) * 0.5;
                    float offsetPerPetal = 360 / petals;
                    GlStateManager.pushMatrix();
                    GlStateManager.translatef((float)-0.05f, (float)-0.5f, (float)0.0f);
                    GlStateManager.scalef((float)v, (float)v, (float)v);
                    for (int i = 0; i < petals; ++i) {
                        float offset = offsetPerPetal * (float)i;
                        float deg = (int)(ticks / 0.25 % 360.0 + (double)offset);
                        float rad = deg * (float)Math.PI / 180.0f;
                        float radiusX = (float)((double)1.2f + (double)0.1f * Math.sin(ticks / 6.0));
                        float radiusZ = (float)((double)1.2f + (double)0.1f * Math.cos(ticks / 6.0));
                        float x = (float)((double)radiusX * Math.cos(rad));
                        float z = (float)((double)radiusZ * Math.sin(rad));
                        float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                        GlStateManager.pushMatrix();
                        GlStateManager.translatef((float)x, (float)y, (float)z);
                        float xRotate = (float)Math.sin(ticks * 0.25) / 2.0f;
                        float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                        float zRotate = (float)Math.cos(ticks * 0.25) / 2.0f;
                        GlStateManager.translatef((float)(v /= 2.0f), (float)v, (float)v);
                        GlStateManager.rotatef((float)deg, (float)xRotate, (float)yRotate, (float)zRotate);
                        GlStateManager.translatef((float)(-v), (float)(-v), (float)(-v));
                        v *= 2.0f;
                        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        ItemStack stack = altar.getItemHandler().getStackInSlot(i);
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
                        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
                        GlStateManager.popMatrix();
                    }
                    GlStateManager.popMatrix();
                }
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            float alpha = lava ? 1.0f : 0.7f;
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.disableAlphaTest();
            if (lava) {
                GlStateManager.disableLighting();
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.translatef((float)w, (float)-0.3f, (float)w);
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)s, (float)s, (float)s);
            TextureAtlasSprite sprite = lava ? Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150353_l.func_176223_P()).func_177554_e() : Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150355_j.func_176223_P()).func_177554_e();
            int color = lava ? Fluids.field_204547_b.getAttributes().getColor((IEnviromentBlockReader)altar.func_145831_w(), altar.func_174877_v()) : Fluids.field_204546_a.getAttributes().getColor((IEnviromentBlockReader)altar.func_145831_w(), altar.func_174877_v());
            this.renderIcon(sprite, color, alpha);
            if (lava) {
                GlStateManager.enableLighting();
            }
            GlStateManager.enableAlphaTest();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
    }

    private void renderIcon(TextureAtlasSprite sprite, int color, float alpha) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        tessellator.func_178180_c().func_181662_b(0.0, 16.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181669_b(red, green, blue, (int)(alpha * 255.0f)).func_181675_d();
        tessellator.func_178180_c().func_181662_b(16.0, 16.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181669_b(red, green, blue, (int)(alpha * 255.0f)).func_181675_d();
        tessellator.func_178180_c().func_181662_b(16.0, 0.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181669_b(red, green, blue, (int)(alpha * 255.0f)).func_181675_d();
        tessellator.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181669_b(red, green, blue, (int)(alpha * 255.0f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

