/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ManaInfusionProcessor
implements IComponentProcessor {
    private List<RecipeManaInfusion> recipes;
    private boolean hasCustomHeading;

    public void setup(IVariableProvider<String> variables) {
        if (variables.has("recipes") && variables.has("group")) {
            Botania.LOGGER.warn("Mana infusion template has both 'recipes' and 'group', ignoring 'recipes'");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (variables.has("group")) {
            String group = (String)variables.get("group");
            BotaniaAPI.manaInfusionRecipes.values().stream().filter(r -> r.getGroup().equals(group)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        } else {
            for (String s : ((String)variables.get("recipes")).split(";")) {
                RecipeManaInfusion recipe = BotaniaAPI.manaInfusionRecipes.get(new ResourceLocation(s));
                if (recipe != null) {
                    builder.add((Object)recipe);
                    continue;
                }
                Botania.LOGGER.warn("Mana infusion template references nonexistent recipe {}", (Object)s);
            }
        }
        this.recipes = builder.build();
        this.hasCustomHeading = variables.has("heading");
    }

    public String process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        switch (key) {
            case "heading": {
                if (!this.hasCustomHeading) {
                    return this.recipes.get(0).getOutput().func_200301_q().getString();
                }
                return null;
            }
            case "input": {
                return PatchouliUtils.interweaveIngredients(this.recipes.stream().map(RecipeManaInfusion::getInput).collect(Collectors.toList()));
            }
            case "output": {
                return this.recipes.stream().map(RecipeManaInfusion::getOutput).map(arg_0 -> ((PatchouliAPI.IPatchouliAPI)PatchouliAPI.instance).serializeItemStack(arg_0)).collect(Collectors.joining(","));
            }
            case "catalyst": {
                return this.recipes.stream().map(RecipeManaInfusion::getCatalyst).map(state -> {
                    if (state == null) {
                        return ItemStack.field_190927_a;
                    }
                    return new ItemStack((IItemProvider)state.func_177230_c().func_199767_j());
                }).map(arg_0 -> ((PatchouliAPI.IPatchouliAPI)PatchouliAPI.instance).serializeItemStack(arg_0)).collect(Collectors.joining(","));
            }
            case "mana": {
                return this.recipes.stream().mapToInt(RecipeManaInfusion::getManaToConsume).mapToObj(Integer::toString).collect(Collectors.joining(";"));
            }
            case "drop": {
                return I18n.func_135052_a((String)"botaniamisc.drop", (Object[])new Object[0]) + TextFormatting.BOLD + " (?)";
            }
            case "dropTip0": 
            case "dropTip1": {
                return I18n.func_135052_a((String)("botaniamisc.dropTip" + key.substring(7)), (Object[])new Object[]{TextFormatting.GREEN + RenderHelper.getKeyDisplayString("key.drop") + TextFormatting.WHITE});
            }
        }
        return null;
    }
}

