/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ElvenTradeProcessor
implements IComponentProcessor {
    private List<RecipeElvenTrade> recipes;
    private int longestIngredientSize;
    private int mostInputs;
    private int mostOutputs;

    public void setup(IVariableProvider<String> variables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String s : ((String)variables.get("recipes")).split(";")) {
            RecipeElvenTrade recipeElvenTrade = BotaniaAPI.elvenTradeRecipes.get(new ResourceLocation(s));
            if (recipeElvenTrade == null) continue;
            builder.add((Object)recipeElvenTrade);
        }
        this.recipes = builder.build();
        for (RecipeElvenTrade recipe : this.recipes) {
            List<Ingredient> inputs = recipe.getInputs();
            for (Ingredient ingredient : inputs) {
                int length = ingredient.func_193365_a().length;
                if (length <= this.longestIngredientSize) continue;
                this.longestIngredientSize = length;
            }
            if (inputs.size() > this.mostInputs) {
                this.mostInputs = inputs.size();
            }
            if (recipe.getOutputs().size() <= this.mostOutputs) continue;
            this.mostOutputs = recipe.getOutputs().size();
        }
    }

    public String process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            return this.recipes.get(0).getOutputs().get(0).func_200301_q().getString();
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            if (index < this.mostInputs) {
                return this.interweaveIngredients(index);
            }
            return null;
        }
        if (key.startsWith("output")) {
            int index = Integer.parseInt(key.substring(6)) - 1;
            if (index < this.mostOutputs) {
                return this.recipes.stream().map(RecipeElvenTrade::getOutputs).map(l -> index < l.size() ? (ItemStack)l.get(index) : ItemStack.field_190927_a).map(arg_0 -> ((PatchouliAPI.IPatchouliAPI)PatchouliAPI.instance).serializeItemStack(arg_0)).collect(Collectors.joining(","));
            }
            return null;
        }
        return null;
    }

    private String interweaveIngredients(int inputIndex) {
        List<Ingredient> recipes = this.recipes.stream().map(RecipeElvenTrade::getInputs).map(ingredients -> {
            if (inputIndex < ingredients.size()) {
                return (Ingredient)ingredients.get(inputIndex);
            }
            return Ingredient.field_193370_a;
        }).collect(Collectors.toList());
        return PatchouliUtils.interweaveIngredients(recipes, this.longestIngredientSize);
    }
}

