/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.client.core.handler.LightningHandler;
import vazkii.botania.client.fx.FXLightningBoltPoint;
import vazkii.botania.client.fx.FXLightningSegment;
import vazkii.botania.common.core.helper.Vector3;

public class FXLightning
extends Particle {
    private static final int fadetime = 20;
    private final Map<Integer, Integer> splitParents = new HashMap<Integer, Integer>();
    private final double length;
    private final Random rand;
    private final int colorOuter;
    private final int colorInner;
    private List<FXLightningSegment> segments = new ArrayList<FXLightningSegment>();
    private int segmentCount = 1;
    private int splitCount;
    private float speed = 1.5f;

    public FXLightning(World world, Vector3 sourcevec, Vector3 targetvec, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
        super(world, sourcevec.x, sourcevec.y, sourcevec.z);
        this.rand = new Random(seed);
        this.speed = ticksPerMeter;
        this.colorOuter = colorOuter;
        this.colorInner = colorInner;
        this.length = targetvec.subtract(sourcevec).mag();
        this.field_70547_e = 20 + this.rand.nextInt(20) - 10;
        this.field_70546_d = -((int)(this.length * (double)this.speed));
        this.segments.add(new FXLightningSegment(sourcevec, targetvec));
        this.fractal(2, this.length / 1.5, 0.7f, 0.7f, 45.0);
        this.fractal(2, this.length / 4.0, 0.5, 0.8f, 50.0);
        this.fractal(2, this.length / 15.0, 0.5, 0.9f, 55.0);
        this.fractal(2, this.length / 30.0, 0.5, 1.0, 60.0);
        this.fractal(2, this.length / 60.0, 0.0, 0.0, 0.0);
        this.fractal(2, this.length / 100.0, 0.0, 0.0, 0.0);
        this.fractal(2, this.length / 400.0, 0.0, 0.0, 0.0);
        this.calculateCollisionAndDiffs();
        this.segments.sort((o1, o2) -> Float.compare(o2.light, o1.light));
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo info, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        LightningHandler.queuedLightningBolts.offer(this);
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217606_f;
    }

    public void renderBolt(int pass, boolean inner) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        float boltAge = this.field_70546_d < 0 ? 0.0f : (float)this.field_70546_d / (float)this.field_70547_e;
        float mainAlpha = pass == 0 ? (1.0f - boltAge) * 0.4f : 1.0f - boltAge * 0.5f;
        int expandTime = (int)(this.length * (double)this.speed);
        int renderstart = (int)((float)(expandTime / 2 - this.field_70547_e + this.field_70546_d) / (float)(expandTime / 2) * (float)this.segmentCount);
        int renderend = (int)((float)(this.field_70546_d + expandTime) / (float)expandTime * (float)this.segmentCount);
        for (FXLightningSegment rendersegment : this.segments) {
            Vector3 roundend;
            if (rendersegment.segmentNo < renderstart || rendersegment.segmentNo > renderend) continue;
            Vector3 playerVec = FXLightning.getRelativeViewVector(rendersegment.startPoint.point).multiply(-1.0);
            double width = (double)0.025f * (playerVec.mag() / 5.0 + 1.0) * (double)(1.0f + rendersegment.light) * 0.5;
            Vector3 diff1 = playerVec.crossProduct(rendersegment.prevDiff).normalize().multiply(width / (double)rendersegment.sinPrev);
            Vector3 diff2 = playerVec.crossProduct(rendersegment.nextDiff).normalize().multiply(width / (double)rendersegment.sinNext);
            Vector3 startvec = rendersegment.startPoint.point;
            Vector3 endvec = rendersegment.endPoint.point;
            int color = inner ? this.colorInner : this.colorOuter;
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            int a = (int)(mainAlpha * rendersegment.light * 255.0f);
            wr.func_181662_b(endvec.x - diff2.x, endvec.y - diff2.y, endvec.z - diff2.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(startvec.x - diff1.x, startvec.y - diff1.y, startvec.z - diff1.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(startvec.x + diff1.x, startvec.y + diff1.y, startvec.z + diff1.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(endvec.x + diff2.x, endvec.y + diff2.y, endvec.z + diff2.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            if (rendersegment.next == null) {
                roundend = rendersegment.endPoint.point.add(rendersegment.diff.normalize().multiply(width));
                wr.func_181662_b(roundend.x - diff2.x, roundend.y - diff2.y, roundend.z - diff2.z).func_187315_a(0.0, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
                wr.func_181662_b(endvec.x - diff2.x, endvec.y - diff2.y, endvec.z - diff2.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
                wr.func_181662_b(endvec.x + diff2.x, endvec.y + diff2.y, endvec.z + diff2.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
                wr.func_181662_b(roundend.x + diff2.x, roundend.y + diff2.y, roundend.z + diff2.z).func_187315_a(0.0, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            }
            if (rendersegment.prev != null) continue;
            roundend = rendersegment.startPoint.point.subtract(rendersegment.diff.normalize().multiply(width));
            wr.func_181662_b(startvec.x - diff1.x, startvec.y - diff1.y, startvec.z - diff1.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(roundend.x - diff1.x, roundend.y - diff1.y, roundend.z - diff1.z).func_187315_a(0.0, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(roundend.x + diff1.x, roundend.y + diff1.y, roundend.z + diff1.z).func_187315_a(0.0, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(startvec.x + diff1.x, startvec.y + diff1.y, startvec.z + diff1.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    private void fractal(int splits, double amount, double splitChance, double splitLength, double splitAngle) {
        List<FXLightningSegment> oldSegments = this.segments;
        this.segments = new ArrayList<FXLightningSegment>();
        for (FXLightningSegment segment : oldSegments) {
            int i;
            FXLightningSegment prev = segment.prev;
            Vector3 subsegment = segment.diff.multiply(1.0f / (float)splits);
            FXLightningBoltPoint[] newpoints = new FXLightningBoltPoint[splits + 1];
            Vector3 startpoint = segment.startPoint.point;
            newpoints[0] = segment.startPoint;
            newpoints[splits] = segment.endPoint;
            for (i = 1; i < splits; ++i) {
                Vector3 randoff = segment.diff.perpendicular().normalize().rotate(this.rand.nextFloat() * 360.0f, segment.diff);
                randoff = randoff.multiply((double)(this.rand.nextFloat() - 0.5f) * amount * 2.0);
                Vector3 basepoint = startpoint.add(subsegment.multiply(i));
                newpoints[i] = new FXLightningBoltPoint(basepoint, randoff);
            }
            for (i = 0; i < splits; ++i) {
                FXLightningSegment next = new FXLightningSegment(newpoints[i], newpoints[i + 1], segment.light, segment.segmentNo * splits + i, segment.splitNo);
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
                if (i != 0 && (double)this.rand.nextFloat() < splitChance) {
                    Vector3 splitrot = next.diff.xCrossProduct().rotate(this.rand.nextFloat() * 360.0f, next.diff);
                    Vector3 diff = next.diff.rotate((double)(this.rand.nextFloat() * 0.66f + 0.33f) * splitAngle, splitrot).multiply(splitLength);
                    ++this.splitCount;
                    this.splitParents.put(this.splitCount, next.splitNo);
                    FXLightningSegment split = new FXLightningSegment(newpoints[i], new FXLightningBoltPoint(newpoints[i + 1].basepoint, newpoints[i + 1].offsetvec.add(diff)), segment.light / 2.0f, next.segmentNo, this.splitCount);
                    split.prev = prev;
                    this.segments.add(split);
                }
                prev = next;
                this.segments.add(next);
            }
            if (segment.next == null) continue;
            segment.next.prev = prev;
        }
        this.segmentCount *= splits;
    }

    private float rayTraceResistance(Vector3 start, Vector3 end, float prevresistance) {
        Entity viewer = Minecraft.func_71410_x().field_175622_Z;
        RayTraceContext ctx = new RayTraceContext(start.toVec3D(), end.toVec3D(), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, viewer);
        BlockRayTraceResult mop = this.field_187122_b.func_217299_a(ctx);
        if (mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = mop.func_216350_a();
            Block block = this.field_187122_b.func_180495_p(pos).func_177230_c();
            if (this.field_187122_b.func_175623_d(pos)) {
                return prevresistance;
            }
            return prevresistance + block.func_149638_a() + 0.3f;
        }
        return prevresistance;
    }

    private void calculateCollisionAndDiffs() {
        HashMap<Integer, Integer> lastactivesegment = new HashMap<Integer, Integer>();
        this.segments.sort((o1, o2) -> {
            int comp = Integer.compare(o1.splitNo, o2.splitNo);
            if (comp == 0) {
                return Integer.compare(o1.segmentNo, o2.segmentNo);
            }
            return comp;
        });
        int lastSplitCalc = 0;
        int lastActiveSegment = 0;
        float splitResistance = 0.0f;
        for (FXLightningSegment segment : this.segments) {
            if (segment.splitNo > lastSplitCalc) {
                lastactivesegment.put(lastSplitCalc, lastActiveSegment);
                lastSplitCalc = segment.splitNo;
                lastActiveSegment = (Integer)lastactivesegment.get(this.splitParents.get(segment.splitNo));
                float f = splitResistance = lastActiveSegment < segment.segmentNo ? 50.0f : 0.0f;
            }
            if (splitResistance >= 40.0f * segment.light) continue;
            splitResistance = this.rayTraceResistance(segment.startPoint.point, segment.endPoint.point, splitResistance);
            lastActiveSegment = segment.segmentNo;
        }
        lastactivesegment.put(lastSplitCalc, lastActiveSegment);
        lastSplitCalc = 0;
        lastActiveSegment = (Integer)lastactivesegment.get(0);
        Iterator<FXLightningSegment> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            FXLightningSegment segment;
            segment = iterator.next();
            if (lastSplitCalc != segment.splitNo) {
                lastSplitCalc = segment.splitNo;
                lastActiveSegment = (Integer)lastactivesegment.get(segment.splitNo);
            }
            if (segment.segmentNo > lastActiveSegment) {
                iterator.remove();
            }
            segment.calcEndDiffs();
        }
    }

    private static Vector3 getRelativeViewVector(Vector3 pos) {
        Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
        return new Vector3((double)((float)renderEntity.field_70165_t) - pos.x, (double)((float)renderEntity.field_70163_u + renderEntity.func_70047_e()) - pos.y, (double)((float)renderEntity.field_70161_v) - pos.z);
    }
}

