/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.item.ItemAstrolabe;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public final class AstrolabePreviewHandler {
    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        for (PlayerEntity player : world.func_217369_A()) {
            Block block;
            ItemStack currentStack = player.func_184614_ca();
            if (currentStack.func_190926_b() || !(currentStack.func_77973_b() instanceof ItemAstrolabe)) {
                currentStack = player.func_184592_cb();
            }
            if (currentStack.func_190926_b() || !(currentStack.func_77973_b() instanceof ItemAstrolabe) || (block = ItemAstrolabe.getBlock(currentStack)) == Blocks.field_150350_a) continue;
            AstrolabePreviewHandler.renderPlayerLook(player, currentStack);
        }
    }

    private static void renderPlayerLook(PlayerEntity player, ItemStack stack) {
        List<BlockPos> coords = ItemAstrolabe.getBlocksToPlace(stack, player);
        if (ItemAstrolabe.hasBlocks(stack, player, coords)) {
            BlockState state = ItemAstrolabe.getBlockState(stack);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            ShaderHelper.useShader(ShaderHelper.alpha, shader -> {
                int alpha = GLX.glGetUniformLocation((int)shader, (CharSequence)"alpha");
                ShaderHelper.FLOAT_BUF.position(0);
                ShaderHelper.FLOAT_BUF.put(0, 0.4f);
                GLX.glUniform1((int)alpha, (FloatBuffer)ShaderHelper.FLOAT_BUF);
            });
            for (BlockPos coord : coords) {
                AstrolabePreviewHandler.renderBlockAt(state, coord);
            }
            ShaderHelper.releaseShader();
            GL11.glPopMatrix();
        }
    }

    private static void renderBlockAt(BlockState state, BlockPos pos) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
        GlStateManager.disableDepthTest();
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.translatef((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        brd.func_175016_a(state, 1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableDepthTest();
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
    }
}

