/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.capability.FloatingFlowerImpl;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.string.TileRedStringRelay;
import vazkii.botania.common.lib.ModTags;

public class TileEntitySpecialFlower
extends TileEntity
implements ITickableTileEntity,
IWandBindable {
    public static final ResourceLocation DING_SOUND_EVENT = new ResourceLocation("botania", "ding");
    public static final int SLOWDOWN_FACTOR_PODZOL = 5;
    public static final int SLOWDOWN_FACTOR_MYCEL = 10;
    private final IFloatingFlower floatingData = new FloatingFlowerImpl(){

        @Override
        public ItemStack getDisplayStack() {
            ResourceLocation id = TileEntitySpecialFlower.this.func_200662_C().getRegistryName();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item != null) {
                return new ItemStack((IItemProvider)item);
            }
            return super.getDisplayStack();
        }
    };
    private final LazyOptional<IFloatingFlower> floatingDataCap = LazyOptional.of(() -> this.floatingData);
    public int ticksExisted = 0;
    public boolean overgrowth = false;
    public boolean overgrowthBoost = false;
    private BlockPos positionOverride;
    public static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_FLOATING_DATA = "floating";

    public TileEntitySpecialFlower(TileEntityType<?> type) {
        super(type);
    }

    public final void func_73660_a() {
        TileEntity tileBelow = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tileBelow instanceof TileRedStringRelay) {
            BlockPos coords = ((TileRedStringRelay)tileBelow).getBinding();
            if (coords != null) {
                this.positionOverride = coords;
                this.tickFlower();
                return;
            }
            this.positionOverride = null;
        } else {
            this.positionOverride = null;
        }
        boolean special = this.isOnSpecialSoil();
        if (special) {
            this.overgrowth = true;
            if (this.isOvergrowthAffected()) {
                this.tickFlower();
                this.overgrowthBoost = true;
            }
        }
        this.tickFlower();
        this.overgrowth = false;
        this.overgrowthBoost = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaAPI.FLOATING_FLOWER_CAP && this.func_145830_o() && this.func_145831_w().func_180495_p(this.func_174877_v()).func_203425_a(ModTags.Blocks.SPECIAL_FLOATING_FLOWERS)) {
            return this.floatingDataCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isFloating() {
        return this.getCapability(BotaniaAPI.FLOATING_FLOWER_CAP).isPresent();
    }

    private boolean isOnSpecialSoil() {
        if (this.isFloating()) {
            return false;
        }
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.enchantedSoil;
    }

    public final BlockPos getEffectivePos() {
        return this.positionOverride != null ? this.positionOverride : this.func_174877_v();
    }

    protected void tickFlower() {
        ++this.ticksExisted;
    }

    public final void func_145839_a(CompoundNBT cmp) {
        super.func_145839_a(cmp);
        if (cmp.func_74764_b(TAG_TICKS_EXISTED)) {
            this.ticksExisted = cmp.func_74762_e(TAG_TICKS_EXISTED);
        }
        this.readFromPacketNBT(cmp);
    }

    @Nonnull
    public final CompoundNBT func_189515_b(CompoundNBT cmp) {
        cmp = super.func_189515_b(cmp);
        cmp.func_74768_a(TAG_TICKS_EXISTED, this.ticksExisted);
        this.writeToPacketNBT(cmp);
        return cmp;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT cmp = new CompoundNBT();
        this.writeToPacketNBT(cmp);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, cmp);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        IFloatingFlower.IslandType oldType = this.floatingData.getIslandType();
        this.readFromPacketNBT(packet.func_148857_g());
        if (oldType != this.floatingData.getIslandType() && this.isFloating()) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 0);
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void writeToPacketNBT(CompoundNBT cmp) {
        if (this.isFloating()) {
            cmp.func_218657_a(TAG_FLOATING_DATA, BotaniaAPI.FLOATING_FLOWER_CAP.writeNBT((Object)this.floatingData, null));
        }
    }

    public void readFromPacketNBT(CompoundNBT cmp) {
        if (cmp.func_74764_b(TAG_FLOATING_DATA)) {
            BotaniaAPI.FLOATING_FLOWER_CAP.readNBT((Object)this.floatingData, null, (INBT)cmp.func_74775_l(TAG_FLOATING_DATA));
        }
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public boolean onWanded(PlayerEntity player, ItemStack wand) {
        return false;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
    }

    public boolean onBlockActivated(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return false;
    }

    public void onBlockAdded(World world, BlockPos pos, BlockState state) {
    }

    public void onBlockHarvested(World world, BlockPos pos, BlockState state, PlayerEntity player) {
    }

    public List<ItemStack> getDrops(List<ItemStack> list, LootContext.Builder ctx) {
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getBinding() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RadiusDescriptor getRadius() {
        return null;
    }

    @Override
    public boolean canSelect(PlayerEntity player, ItemStack wand, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    public boolean bindTo(PlayerEntity player, ItemStack wand, BlockPos pos, Direction side) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc) {
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public int getPowerLevel(Direction side) {
        return 0;
    }

    public boolean isOvergrowthAffected() {
        return true;
    }

    public int getSlowdownFactor() {
        if (this.isFloating()) {
            IFloatingFlower.IslandType type = this.floatingData.getIslandType();
            if (type == IFloatingFlower.IslandType.MYCEL) {
                return 10;
            }
            if (type == IFloatingFlower.IslandType.PODZOL) {
                return 5;
            }
        } else {
            Block below = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c();
            if (below == Blocks.field_150391_bh) {
                return 10;
            }
            if (below == Blocks.field_196661_l) {
                return 5;
            }
        }
        return 0;
    }

    @Nonnull
    public IModelData getModelData() {
        if (this.isFloating()) {
            return new ModelDataMap.Builder().withInitial(BotaniaStateProps.FLOATING_DATA, (Object)this.floatingData).build();
        }
        return EmptyModelData.INSTANCE;
    }
}

