/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.brew;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;

public class Brew {
    private final String key;
    private final String name;
    private final int color;
    private final int cost;
    private final List<EffectInstance> effects;
    private boolean canInfuseBloodPendant = true;
    private boolean canInfuseIncense = true;

    public Brew(String key, String name, int color, int cost, EffectInstance ... effects) {
        this.key = key;
        this.name = name;
        this.color = color;
        this.cost = cost;
        this.effects = ImmutableList.copyOf((Object[])effects);
    }

    public Brew setNotBloodPendantInfusable() {
        this.canInfuseBloodPendant = false;
        return this;
    }

    public Brew setNotIncenseInfusable() {
        this.canInfuseIncense = false;
        return this;
    }

    public boolean canInfuseBloodPendant() {
        return this.canInfuseBloodPendant;
    }

    public boolean canInfuseIncense() {
        return this.canInfuseIncense;
    }

    public String getKey() {
        return this.key;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName();
    }

    public int getColor(ItemStack stack) {
        return this.color;
    }

    public int getManaCost() {
        return this.cost;
    }

    public int getManaCost(ItemStack stack) {
        return this.getManaCost();
    }

    public List<EffectInstance> getPotionEffects(ItemStack stack) {
        return this.effects;
    }
}

