/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class StonecuttingProvider
extends RecipeProvider {
    public StonecuttingProvider(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            StonecuttingProvider.registerForMetamorphic(variant, consumer);
        }
        for (String color : LibBlockNames.PAVEMENT_VARIANTS) {
            StonecuttingProvider.registerForPavement(color, consumer);
        }
        for (String variant : LibBlockNames.QUARTZ_VARIANTS) {
            StonecuttingProvider.registerForQuartz(variant, consumer);
        }
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.shimmerrock, (IItemProvider)ModFluffBlocks.shimmerrockSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.shimmerrock, (IItemProvider)ModFluffBlocks.shimmerrockStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModBlocks.livingrockBrick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockBrickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockBrickStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModBlocks.livingrockBrickChiseled));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrick, (IItemProvider)ModFluffBlocks.livingrockBrickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrick, (IItemProvider)ModFluffBlocks.livingrockBrickStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrick, (IItemProvider)ModBlocks.livingrockBrickChiseled));
    }

    private static void registerForQuartz(String variant, Consumer<IFinishedRecipe> consumer) {
        Block base = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix(variant));
        Block slab = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix(variant + "_slab"));
        Block stairs = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix(variant + "_stairs"));
        Block chiseled = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("chiseled_" + variant));
        Block pillar = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix(variant + "_pillar"));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)slab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)stairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)chiseled));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)pillar));
    }

    private static void registerForPavement(String color, Consumer<IFinishedRecipe> consumer) {
        Block base = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix(color + "_pavement"));
        Block slab = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix(color + "_pavement" + "_slab"));
        Block stair = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix(color + "_pavement" + "_stairs"));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)slab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)stair));
    }

    private static void registerForMetamorphic(String variant, Consumer<IFinishedRecipe> consumer) {
        Block base = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone"));
        Block slab = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone" + "_slab"));
        Block stair = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone" + "_stairs"));
        Block brick = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks"));
        Block brickSlab = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks" + "_slab"));
        Block brickStair = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks" + "_stairs"));
        Block chiseledBrick = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("chiseled_metamorphic_" + variant + "_bricks"));
        Block cobble = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone"));
        Block cobbleSlab = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone" + "_slab"));
        Block cobbleStair = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone" + "_stairs"));
        Block cobbleWall = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone" + "_wall"));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)slab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)stair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)brick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)brickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)brickStair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)chiseledBrick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)brick, (IItemProvider)brickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)brick, (IItemProvider)brickStair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)brick, (IItemProvider)chiseledBrick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)cobble, (IItemProvider)cobbleSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)cobble, (IItemProvider)cobbleStair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)cobble, (IItemProvider)cobbleWall));
    }

    @Nonnull
    public String func_200397_b() {
        return "Botania stonecutting recipes";
    }

    private static ResourceLocation idFor(IItemProvider a, IItemProvider b) {
        return ResourceLocationHelper.prefix("stonecutting/" + a.func_199767_j().getRegistryName().func_110623_a() + "_to_" + b.func_199767_j().getRegistryName().func_110623_a());
    }

    private static IFinishedRecipe stonecutting(IItemProvider input, IItemProvider output) {
        return StonecuttingProvider.stonecutting(input, output, 1);
    }

    private static IFinishedRecipe stonecutting(IItemProvider input, IItemProvider output, int count) {
        return new Result(StonecuttingProvider.idFor(input, output), IRecipeSerializer.field_222175_s, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), output.func_199767_j(), count);
    }

    public static class Result
    extends SingleItemRecipeBuilder.Result {
        public Result(ResourceLocation id, IRecipeSerializer<?> serializer, Ingredient input, Item result, int count) {
            super(id, serializer, "", input, result, count, null, null);
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

