/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.network;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.recipe.RecipeRuneAltar;

public class PacketSyncRecipes {
    private Map<ResourceLocation, RecipeBrew> brew;
    private Map<ResourceLocation, RecipeElvenTrade> elven;
    private Map<ResourceLocation, RecipeManaInfusion> manaInfusion;
    private Map<ResourceLocation, RecipePetals> petal;
    private Map<ResourceLocation, RecipePureDaisy> pureDaisy;
    private Map<ResourceLocation, RecipeRuneAltar> runeAltar;

    public PacketSyncRecipes(Map<ResourceLocation, RecipeBrew> brew, Map<ResourceLocation, RecipeElvenTrade> elven, Map<ResourceLocation, RecipeManaInfusion> manaInfusion, Map<ResourceLocation, RecipePetals> petal, Map<ResourceLocation, RecipePureDaisy> pureDaisy, Map<ResourceLocation, RecipeRuneAltar> runeAltar) {
        this.brew = brew;
        this.elven = elven;
        this.manaInfusion = manaInfusion;
        this.petal = petal;
        this.pureDaisy = pureDaisy;
        this.runeAltar = runeAltar;
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.brew.size());
        for (RecipeBrew recipeBrew : this.brew.values()) {
            recipeBrew.write(buf);
        }
        buf.func_150787_b(this.elven.size());
        for (RecipeElvenTrade recipeElvenTrade : this.elven.values()) {
            recipeElvenTrade.write(buf);
        }
        buf.func_150787_b(this.manaInfusion.size());
        for (RecipeManaInfusion recipeManaInfusion : this.manaInfusion.values()) {
            recipeManaInfusion.write(buf);
        }
        buf.func_150787_b(this.petal.size());
        for (RecipePetals recipePetals : this.petal.values()) {
            recipePetals.write(buf);
        }
        buf.func_150787_b(this.pureDaisy.size());
        for (RecipePureDaisy recipePureDaisy : this.pureDaisy.values()) {
            recipePureDaisy.write(buf);
        }
        buf.func_150787_b(this.runeAltar.size());
        for (RecipeRuneAltar recipeRuneAltar : this.runeAltar.values()) {
            recipeRuneAltar.write(buf);
        }
    }

    public static PacketSyncRecipes decode(PacketBuffer buf) {
        int brewCount = buf.func_150792_a();
        Map<ResourceLocation, RecipeBrew> brew = Stream.generate(() -> RecipeBrew.read(buf)).limit(brewCount).collect(Collectors.toMap(RecipeBrew::getId, r -> r));
        int elvenCount = buf.func_150792_a();
        Map<ResourceLocation, RecipeElvenTrade> elven = Stream.generate(() -> RecipeElvenTrade.read(buf)).limit(elvenCount).collect(Collectors.toMap(RecipeElvenTrade::getId, r -> r));
        int manaInfusionCount = buf.func_150792_a();
        Map<ResourceLocation, RecipeManaInfusion> manaInfusion = Stream.generate(() -> RecipeManaInfusion.read(buf)).limit(manaInfusionCount).collect(Collectors.toMap(RecipeManaInfusion::getId, r -> r));
        int petalCount = buf.func_150792_a();
        Map<ResourceLocation, RecipePetals> petal = Stream.generate(() -> RecipePetals.read(buf)).limit(petalCount).collect(Collectors.toMap(RecipePetals::getId, r -> r));
        int pureDaisyCount = buf.func_150792_a();
        Map<ResourceLocation, RecipePureDaisy> pureDaisy = Stream.generate(() -> RecipePureDaisy.read(buf)).limit(pureDaisyCount).collect(Collectors.toMap(RecipePureDaisy::getId, r -> r));
        int runeCount = buf.func_150792_a();
        Map<ResourceLocation, RecipeRuneAltar> rune = Stream.generate(() -> RecipeRuneAltar.read(buf)).limit(runeCount).collect(Collectors.toMap(RecipeRuneAltar::getId, r -> r));
        return new PacketSyncRecipes(brew, elven, manaInfusion, petal, pureDaisy, rune);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BotaniaAPI.brewRecipes = this.brew;
            BotaniaAPI.elvenTradeRecipes = this.elven;
            BotaniaAPI.manaInfusionRecipes = this.manaInfusion;
            BotaniaAPI.petalRecipes = this.petal;
            BotaniaAPI.pureDaisyRecipes = this.pureDaisy;
            BotaniaAPI.runeAltarRecipes = this.runeAltar;
        });
        ctx.get().setPacketHandled(true);
    }
}

