/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.NoteBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileCacophonium;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemCacophonium
extends ItemMod {
    private static final String TAG_SOUND = "sound";
    private static final String TAG_SOUND_NAME = "soundName";

    public ItemCacophonium(Item.Properties props) {
        super(props);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity instanceof MobEntity) {
            MobEntity living = (MobEntity)entity;
            SoundEvent sound = null;
            if (living instanceof CreeperEntity) {
                sound = SoundEvents.field_187572_ar;
            } else if (living instanceof SlimeEntity) {
                sound = ((SlimeEntity)living).func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
            } else {
                try {
                    sound = (SoundEvent)ObfuscationReflectionHelper.findMethod(MobEntity.class, (String)"func_184639_G", (Class[])new Class[0]).invoke((Object)living, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException ignored) {
                    Botania.LOGGER.debug("Couldn't get living sound");
                }
            }
            if (sound != null) {
                ItemNBTHelper.setString(stack, TAG_SOUND, sound.getRegistryName().toString());
                ItemNBTHelper.setString(stack, TAG_SOUND_NAME, entity.func_200600_R().func_210760_d());
                player.func_184611_a(hand, stack);
                if (player.field_70170_p.field_72995_K) {
                    player.func_184609_a(hand);
                }
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos;
        World world;
        Block block;
        ItemStack stack = ctx.func_195996_i();
        if (ItemCacophonium.getSound(stack) != null && (block = (world = ctx.func_195991_k()).func_180495_p(pos = ctx.func_195995_a()).func_177230_c()) instanceof NoteBlock) {
            world.func_175656_a(pos, ModBlocks.cacophonium.func_176223_P());
            ((TileCacophonium)world.func_175625_s((BlockPos)pos)).stack = stack.func_77946_l();
            stack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        if (ItemCacophonium.isDOIT(stack)) {
            list.add(new TranslationTextComponent("botaniamisc.justDoIt", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else if (ItemCacophonium.getSound(stack) != null) {
            list.add(new TranslationTextComponent(ItemNBTHelper.getString(stack, TAG_SOUND_NAME, ""), new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack par1ItemStack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemCacophonium.getSound(stack) != null) {
            player.func_184598_c(hand);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (count % (ItemCacophonium.isDOIT(stack) ? 20 : 6) == 0) {
            ItemCacophonium.playSound(player.field_70170_p, stack, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundCategory.PLAYERS, 0.9f);
        }
    }

    public static void playSound(World world, ItemStack stack, double x, double y, double z, SoundCategory category, float volume) {
        if (stack.func_190926_b()) {
            return;
        }
        SoundEvent sound = ItemCacophonium.getSound(stack);
        if (sound != null) {
            world.func_184148_a(null, x, y, z, sound, category, volume, sound == ModSounds.doit ? 1.0f : (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Nullable
    private static SoundEvent getSound(ItemStack stack) {
        if (ItemCacophonium.isDOIT(stack)) {
            return ModSounds.doit;
        }
        try {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(ItemNBTHelper.getString(stack, TAG_SOUND, "")));
        }
        catch (ResourceLocationException ex) {
            return null;
        }
    }

    private static boolean isDOIT(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_200301_q().getString().equalsIgnoreCase("shia labeouf");
    }
}

