/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;

public final class StringObfuscator {
    public static boolean matchesHash(String str, String hash) {
        return StringObfuscator.getHash(str).equals(hash);
    }

    private static String getHash(String str) {
        if (str != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                return new HexBinaryAdapter().marshal(md.digest(StringObfuscator.dontRainbowTableMeOrMySonEverAgain(str).getBytes(StandardCharsets.UTF_8)));
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private static String dontRainbowTableMeOrMySonEverAgain(String str) throws NoSuchAlgorithmException {
        str = str + StringObfuscator.reverseString(str);
        SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
        rand.setSeed(str.getBytes(StandardCharsets.UTF_8));
        int l = str.length();
        int steps = rand.nextInt(l);
        char[] chrs = str.toCharArray();
        for (int i = 0; i < steps; ++i) {
            char c;
            int indB;
            int indA = rand.nextInt(l);
            while ((indB = rand.nextInt(l)) == indA) {
            }
            chrs[indA] = c = (char)(chrs[indA] ^ chrs[indB]);
        }
        return String.copyValueOf(chrs);
    }

    private static String reverseString(String str) {
        return new StringBuilder(str).reverse().toString();
    }
}

