/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.Botania;
import vazkii.botania.common.integration.curios.CurioIntegration;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public abstract class EquipmentHandler {
    public static EquipmentHandler instance;

    public static void init() {
        if (Botania.curiosLoaded) {
            instance = new CurioIntegration();
            FMLJavaModLoadingContext.get().getModEventBus().register(CurioIntegration.class);
            MinecraftForge.EVENT_BUS.register(CurioIntegration.class);
        } else {
            InventoryEquipmentHandler handler = new InventoryEquipmentHandler();
            instance = handler;
            MinecraftForge.EVENT_BUS.addListener(handler::onPlayerTick);
        }
    }

    public static LazyOptional<IItemHandlerModifiable> getAllWorn(LivingEntity living) {
        return instance.getAllWornItems(living);
    }

    public static ItemStack findOrEmpty(Item item, LivingEntity living) {
        return instance.findItem(item, living);
    }

    public static ItemStack findOrEmpty(Predicate<ItemStack> pred, LivingEntity living) {
        return instance.findItem(pred, living);
    }

    public static ICapabilityProvider initBaubleCap(ItemStack stack) {
        if (instance != null) {
            return instance.initCap(stack);
        }
        return null;
    }

    protected abstract LazyOptional<IItemHandlerModifiable> getAllWornItems(LivingEntity var1);

    protected abstract ItemStack findItem(Item var1, LivingEntity var2);

    protected abstract ItemStack findItem(Predicate<ItemStack> var1, LivingEntity var2);

    protected abstract ICapabilityProvider initCap(ItemStack var1);

    public boolean isAccessory(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBauble || stack.func_77973_b() instanceof IManaItem;
    }

    static class InventoryEquipmentHandler
    extends EquipmentHandler {
        private final Map<PlayerEntity, ItemStack[]> map = new WeakHashMap<PlayerEntity, ItemStack[]>();

        InventoryEquipmentHandler() {
        }

        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.START || event.player.field_70170_p.field_72995_K) {
                return;
            }
            PlayerEntity player = event.player;
            player.field_70170_p.func_217381_Z().func_76320_a("botania:tick_wearables");
            ItemStack[] oldStacks = this.map.computeIfAbsent(player, p -> {
                Object[] array = new ItemStack[9];
                Arrays.fill(array, ItemStack.field_190927_a);
                return array;
            });
            PlayerInventory inv = player.field_71071_by;
            for (int i = 0; i < 9; ++i) {
                ItemStack old = oldStacks[i];
                ItemStack current = inv.func_70301_a(i);
                if (!ItemStack.func_77989_b((ItemStack)old, (ItemStack)current)) {
                    if (old.func_77973_b() instanceof ItemBauble) {
                        player.func_110140_aT().func_111148_a(((ItemBauble)old.func_77973_b()).getEquippedAttributeModifiers(old));
                        ((ItemBauble)old.func_77973_b()).onUnequipped(old, (LivingEntity)player);
                    }
                    if (InventoryEquipmentHandler.canEquip(current, (LivingEntity)player)) {
                        player.func_110140_aT().func_111147_b(((ItemBauble)current.func_77973_b()).getEquippedAttributeModifiers(current));
                        ((ItemBauble)current.func_77973_b()).onEquipped(current, (LivingEntity)player);
                    }
                    oldStacks[i] = current.func_77946_l();
                }
                if (!InventoryEquipmentHandler.canEquip(current, (LivingEntity)player)) continue;
                ((ItemBauble)current.func_77973_b()).onWornTick(current, (LivingEntity)player);
            }
            player.field_70170_p.func_217381_Z().func_76319_b();
        }

        @Override
        protected LazyOptional<IItemHandlerModifiable> getAllWornItems(LivingEntity living) {
            if (living instanceof PlayerEntity) {
                return LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)((PlayerEntity)living).field_71071_by), 0, 9));
            }
            return LazyOptional.empty();
        }

        @Override
        protected ItemStack findItem(Item item, LivingEntity living) {
            if (living instanceof PlayerEntity) {
                PlayerInventory inv = ((PlayerEntity)living).field_71071_by;
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack.func_77973_b() != item || !InventoryEquipmentHandler.canEquip(stack, living)) continue;
                    return stack;
                }
            }
            return ItemStack.field_190927_a;
        }

        @Override
        protected ItemStack findItem(Predicate<ItemStack> pred, LivingEntity living) {
            if (living instanceof PlayerEntity) {
                PlayerInventory inv = ((PlayerEntity)living).field_71071_by;
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (!pred.test(stack) || !InventoryEquipmentHandler.canEquip(stack, living)) continue;
                    return stack;
                }
            }
            return ItemStack.field_190927_a;
        }

        @Override
        protected ICapabilityProvider initCap(ItemStack stack) {
            return null;
        }

        private static boolean canEquip(ItemStack stack, LivingEntity player) {
            return stack.func_77973_b() instanceof ItemBauble && ((ItemBauble)stack.func_77973_b()).canEquip(stack, player);
        }
    }
}

