/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.common.block.tile.TileMod;

public class TileCocoon
extends TileMod
implements ITickableTileEntity {
    @ObjectHolder(value="botania:cocoon")
    public static TileEntityType<TileCocoon> TYPE;
    private static final String TAG_TIME_PASSED = "timePassed";
    private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
    private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
    public static final int TOTAL_TIME = 2400;
    public static final int MAX_EMERALDS = 20;
    public static final int MAX_CHORUS_FRUITS = 20;
    public int timePassed;
    public int emeraldsGiven;
    public int chorusFruitGiven;

    public TileCocoon() {
        super(TYPE);
    }

    public void func_73660_a() {
        ++this.timePassed;
        if (this.timePassed >= 2400) {
            this.hatch();
        }
    }

    private void hatch() {
        if (!this.field_145850_b.field_72995_K) {
            this.timePassed = 0;
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            MobEntity entity = null;
            float villagerChance = Math.min(1.0f, (float)this.emeraldsGiven / 20.0f);
            float shulkerChance = Math.min(1.0f, (float)this.chorusFruitGiven / 20.0f);
            if (Math.random() < (double)shulkerChance) {
                entity = (MobEntity)EntityType.field_200738_ad.func_200721_a(this.field_145850_b);
            } else if (Math.random() < (double)villagerChance) {
                VillagerEntity villager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
                if (villager != null) {
                    IVillagerType type = IVillagerType.func_221170_a((Biome)this.field_145850_b.func_180494_b(this.field_174879_c));
                    villager.func_213753_a(villager.func_213700_eh().func_221134_a(type));
                }
                entity = villager;
            } else {
                float specialChance = 0.05f;
                if (Math.random() < (double)specialChance) {
                    int entityType = this.field_145850_b.field_73012_v.nextInt(5);
                    switch (entityType) {
                        case 0: {
                            entity = (MobEntity)EntityType.field_200762_B.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 1: {
                            entity = (MobEntity)EntityType.field_200724_aC.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 2: {
                            entity = (MobEntity)EntityType.field_200781_U.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 3: {
                            entity = (MobEntity)EntityType.field_200783_W.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 4: {
                            entity = (MobEntity)EntityType.field_200769_I.func_200721_a(this.field_145850_b);
                        }
                    }
                } else {
                    int entityType = this.field_145850_b.field_73012_v.nextInt(5);
                    switch (entityType) {
                        case 0: {
                            entity = (MobEntity)EntityType.field_200737_ac.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 1: {
                            if (Math.random() < 0.01) {
                                entity = (MobEntity)EntityType.field_200780_T.func_200721_a(this.field_145850_b);
                                break;
                            }
                            entity = (MobEntity)EntityType.field_200796_j.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 2: {
                            entity = (MobEntity)EntityType.field_200784_X.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 3: {
                            entity = (MobEntity)EntityType.field_200795_i.func_200721_a(this.field_145850_b);
                            break;
                        }
                        case 4: {
                            entity = (MobEntity)EntityType.field_200736_ab.func_200721_a(this.field_145850_b);
                        }
                    }
                }
            }
            if (entity != null) {
                entity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                if (entity instanceof AgeableEntity) {
                    ((AgeableEntity)entity).func_70873_a(-24000);
                }
                entity.func_213386_a((IWorld)this.field_145850_b, this.field_145850_b.func_175649_E(this.func_174877_v()), SpawnReason.EVENT, null, null);
                this.field_145850_b.func_217376_c((Entity)entity);
                entity.func_70656_aK();
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_TIME_PASSED, this.timePassed);
        cmp.func_74768_a(TAG_EMERALDS_GIVEN, this.emeraldsGiven);
        cmp.func_74768_a(TAG_CHORUS_FRUIT_GIVEN, this.chorusFruitGiven);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.timePassed = cmp.func_74762_e(TAG_TIME_PASSED);
        this.emeraldsGiven = cmp.func_74762_e(TAG_EMERALDS_GIVEN);
        this.chorusFruitGiven = cmp.func_74762_e(TAG_CHORUS_FRUIT_GIVEN);
    }
}

