/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class SubTileSpectranthemum
extends TileEntityFunctionalFlower {
    @ObjectHolder(value="botania:spectranthemum")
    public static TileEntityType<SubTileSpectranthemum> TYPE;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final int COST = 24;
    private static final int RANGE = 2;
    private static final int BIND_RANGE = 12;
    private static final String TAG_TELEPORTED = "botania:teleported";
    private BlockPos bindPos = new BlockPos(0, -1, 0);

    public SubTileSpectranthemum() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.func_145831_w().field_72995_K && this.redstoneSignal == 0 && this.func_145831_w().func_175667_e(this.bindPos)) {
            BlockPos pos = this.getEffectivePos();
            boolean did = false;
            List items = this.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(pos.func_177982_a(-2, -2, -2), pos.func_177982_a(3, 3, 3)));
            int slowdown = this.getSlowdownFactor();
            for (ItemEntity item : items) {
                Item sitem;
                ItemStack stack;
                if (item.field_70292_b < 60 + slowdown || !item.func_70089_S() || item.getPersistentData().func_74767_n(TAG_TELEPORTED) || (stack = item.func_92059_d()).func_190926_b() || (sitem = stack.func_77973_b()) instanceof IManaItem) continue;
                int cost = stack.func_190916_E() * 24;
                if (this.getMana() < cost) continue;
                SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 10);
                item.func_70107_b((double)this.bindPos.func_177958_n() + 0.5, (double)this.bindPos.func_177956_o() + 1.5, (double)this.bindPos.func_177952_p() + 0.5);
                item.getPersistentData().func_74757_a(TAG_TELEPORTED, true);
                item.func_213317_d(Vec3d.field_186680_a);
                SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 10);
                this.addMana(-cost);
                did = true;
            }
            if (did) {
                this.sync();
            }
        }
    }

    static void spawnExplosionParticles(Entity item, int p) {
        PacketHandler.sendToNearby(item.field_70170_p, new BlockPos(item), (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ITEM_SMOKE, item.field_70165_t, item.field_70163_u, item.field_70161_v, item.func_145782_y(), p));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 2);
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BIND_X, this.bindPos.func_177958_n());
        cmp.func_74768_a(TAG_BIND_Y, this.bindPos.func_177956_o());
        cmp.func_74768_a(TAG_BIND_Z, this.bindPos.func_177952_p());
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.bindPos = new BlockPos(cmp.func_74762_e(TAG_BIND_X), cmp.func_74762_e(TAG_BIND_Y), cmp.func_74762_e(TAG_BIND_Z));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 10009855;
    }

    @Override
    public int getMaxMana() {
        return 16000;
    }

    @Override
    public boolean bindTo(PlayerEntity player, ItemStack wand, BlockPos pos, Direction side) {
        boolean bound = super.bindTo(player, wand, pos, side);
        if (!bound && !pos.equals((Object)this.bindPos) && pos.func_177951_i((Vec3i)this.getEffectivePos()) <= 144.0 && !pos.equals((Object)this.getEffectivePos())) {
            this.bindPos = pos;
            this.sync();
            return true;
        }
        return bound;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getBinding() {
        return Minecraft.func_71410_x().field_71439_g.func_70093_af() && this.bindPos.func_177956_o() != -1 ? this.bindPos : super.getBinding();
    }
}

