/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;

public class SubTilePureDaisy
extends TileEntitySpecialFlower {
    @ObjectHolder(value="botania:pure_daisy")
    public static TileEntityType<SubTilePureDaisy> TYPE;
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final int UPDATE_ACTIVE_EVENT = 0;
    private static final int RECIPE_COMPLETE_EVENT = 1;
    private static final BlockPos[] POSITIONS;
    private int positionAt = 0;
    private final int[] ticksRemaining = new int[POSITIONS.length];
    private int activePositions = 0;

    public SubTilePureDaisy() {
        super(TYPE);
        Arrays.fill(this.ticksRemaining, -1);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            for (int i = 0; i < POSITIONS.length; ++i) {
                if ((this.activePositions >>> i & 1) <= 0) continue;
                BlockPos coords = this.getEffectivePos().func_177971_a((Vec3i)POSITIONS[i]);
                SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), 1.0f, 1.0f, 1.0f, 5);
                this.field_145850_b.func_195594_a((IParticleData)data, (double)coords.func_177958_n() + Math.random(), (double)coords.func_177956_o() + Math.random(), (double)coords.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
            return;
        }
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        BlockPos acoords = POSITIONS[this.positionAt];
        BlockPos coords = this.getEffectivePos().func_177971_a((Vec3i)acoords);
        World world = this.func_145831_w();
        if (!world.func_175623_d(coords)) {
            world.func_217381_Z().func_76320_a("findRecipe");
            RecipePureDaisy recipe = this.findRecipe(coords);
            world.func_217381_Z().func_76319_b();
            if (recipe != null) {
                if (this.ticksRemaining[this.positionAt] == -1) {
                    this.ticksRemaining[this.positionAt] = recipe.getTime();
                }
                int n = this.positionAt;
                this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    this.ticksRemaining[this.positionAt] = -1;
                    if (recipe.set(world, coords, this)) {
                        world.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.positionAt);
                        if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                            this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)recipe.getOutputState()));
                        }
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = -1;
            }
        } else {
            this.ticksRemaining[this.positionAt] = -1;
        }
        this.updateActivePositions();
    }

    private void updateActivePositions() {
        int newActivePositions = 0;
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            if (this.ticksRemaining[i] <= -1) continue;
            newActivePositions |= 1 << i;
        }
        if (newActivePositions != this.activePositions) {
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, newActivePositions);
        }
    }

    private RecipePureDaisy findRecipe(BlockPos coords) {
        BlockState state = this.func_145831_w().func_180495_p(coords);
        for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes.values()) {
            if (!recipe.matches(this.func_145831_w(), coords, this, state)) continue;
            return recipe;
        }
        return null;
    }

    public boolean func_145842_c(int type, int param) {
        switch (type) {
            case 0: {
                this.activePositions = param;
                return true;
            }
            case 1: {
                if (this.func_145831_w().field_72995_K) {
                    BlockPos coords = this.getEffectivePos().func_177971_a((Vec3i)POSITIONS[param]);
                    for (int i = 0; i < 25; ++i) {
                        double x = (double)coords.func_177958_n() + Math.random();
                        double y = (double)coords.func_177956_o() + Math.random() + 0.5;
                        double z = (double)coords.func_177952_p() + Math.random();
                        WispParticleData data = WispParticleData.wisp((float)Math.random() / 2.0f, 1.0f, 1.0f, 1.0f);
                        this.func_145831_w().func_195594_a((IParticleData)data, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
        }
        return super.func_145842_c(type, param);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        this.positionAt = cmp.func_74762_e(TAG_POSITION);
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            for (int i = 0; i < this.ticksRemaining.length; ++i) {
                this.ticksRemaining[i] = cmp.func_74762_e(TAG_TICKS_REMAINING + i);
            }
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.func_74768_a(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }

    static {
        POSITIONS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(1, 0, 0), new BlockPos(1, 0, -1), new BlockPos(0, 0, -1)};
    }
}

