/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.render.entity.RenderSparkBase;
import vazkii.botania.common.entity.EntityCorporeaSpark;

public class RenderCorporeaSpark
extends RenderSparkBase<EntityCorporeaSpark> {
    public RenderCorporeaSpark(EntityRendererManager manager) {
        super(manager);
    }

    @Override
    public TextureAtlasSprite getBaseIcon(EntityCorporeaSpark entity) {
        return entity.isMaster() ? MiscellaneousIcons.INSTANCE.corporeaWorldIconMaster : MiscellaneousIcons.INSTANCE.corporeaWorldIcon;
    }

    @Override
    public void renderCallback(EntityCorporeaSpark entity, float pticks) {
        int time = entity.getItemDisplayTicks();
        if (time == 0) {
            return;
        }
        float absTime = (float)Math.abs(time) - pticks;
        ItemStack stack = entity.getDisplayedItem();
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float scalef = 0.16666667f;
        GlStateManager.scalef((float)scalef, (float)scalef, (float)scalef);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(absTime / 10.0f));
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(-2.0f + (time < 0 ? -absTime : absTime) / 6.0f));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, entity.field_70170_p, null).func_177554_e();
        if (icon != null) {
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            int pieces = 8;
            float stepU = (maxU - minU) / (float)pieces;
            float stepV = (maxV - minV) / (float)pieces;
            float gap = 1.0f + (time > 0 ? 10.0f - absTime : absTime) * 0.2f;
            int shift = pieces / 2;
            float scale = 1.0f / (float)pieces * 3.0f;
            GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
            for (int i = -shift; i < shift; ++i) {
                GlStateManager.translatef((float)(gap * (float)i), (float)0.0f, (float)0.0f);
                for (int j = -shift; j < shift; ++j) {
                    GlStateManager.translatef((float)0.0f, (float)(gap * (float)j), (float)0.0f);
                    IconHelper.renderIconIn3D(Tessellator.func_178181_a(), minU + stepU * (float)(i + shift), minV + stepV * (float)(j + shift + 1), minU + stepU * (float)(i + shift + 1), minV + stepV * (float)(j + shift), icon.func_94211_a() / pieces, icon.func_94216_b() / pieces, 0.125f);
                    GlStateManager.translatef((float)0.0f, (float)(-gap * (float)j), (float)0.0f);
                }
                GlStateManager.translatef((float)(-gap * (float)i), (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }
}

