/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class BrewRecipeProcessor
implements IComponentProcessor {
    private RecipeBrew recipe;

    public void setup(IVariableProvider<String> variables) {
        this.recipe = BotaniaAPI.brewRecipes.get(new ResourceLocation((String)variables.get("recipe")));
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("heading")) {
            return I18n.func_135052_a((String)"botaniamisc.brewOf", (Object[])new Object[]{I18n.func_135052_a((String)this.recipe.getBrew().getUnlocalizedName(), (Object[])new Object[0])});
        }
        if (key.equals("vial")) {
            return PatchouliAPI.instance.serializeItemStack(this.recipe.getOutput(new ItemStack((IItemProvider)ModItems.vial)));
        }
        if (key.equals("flask")) {
            return PatchouliAPI.instance.serializeItemStack(this.recipe.getOutput(new ItemStack((IItemProvider)ModItems.flask)));
        }
        if (key.startsWith("input")) {
            int indexOffset;
            int requestedIndex = Integer.parseInt(key.substring(5)) - 1;
            int index = requestedIndex - (indexOffset = (6 - this.recipe.getInputs().size()) / 2);
            if (index < this.recipe.getInputs().size() && index >= 0) {
                return PatchouliAPI.instance.serializeIngredient(this.recipe.getInputs().get(index));
            }
            return null;
        }
        if (key.equals("is_offset")) {
            return Boolean.toString(this.recipe.getInputs().size() % 2 == 0);
        }
        return null;
    }
}

