/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;

public class FloatingFlowerModel
implements IUnbakedModel {
    private static final FloatingFlowerModel INIT = new FloatingFlowerModel(null);
    @Nullable
    private final ResourceLocation flower;
    @Nullable
    private IUnbakedModel unbakedFlower = null;
    private final Map<IFloatingFlower.IslandType, IUnbakedModel> unbakedIslands = new HashMap<IFloatingFlower.IslandType, IUnbakedModel>();

    private FloatingFlowerModel(@Nullable ResourceLocation flower) {
        this.flower = flower;
        if (flower != null) {
            this.unbakedFlower = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)flower);
        }
        for (Map.Entry<IFloatingFlower.IslandType, ResourceLocation> e : BotaniaAPIClient.getRegisteredIslandTypeModels().entrySet()) {
            IUnbakedModel unbakedIsland = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)e.getValue());
            this.unbakedIslands.put(e.getKey(), unbakedIsland);
        }
    }

    @Nonnull
    public Collection<ResourceLocation> func_187965_e() {
        ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(BotaniaAPIClient.getRegisteredIslandTypeModels().values());
        if (this.flower != null) {
            ret.add(this.flower);
        }
        return ret;
    }

    @Nonnull
    public Collection<ResourceLocation> func_209559_a(@Nonnull Function<ResourceLocation, IUnbakedModel> modelGetter, @Nonnull Set<String> missingTextureErrors) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>();
        for (IUnbakedModel island : this.unbakedIslands.values()) {
            ret.addAll(island.func_209559_a(modelGetter, missingTextureErrors));
        }
        ret.addAll(this.unbakedFlower.func_209559_a(modelGetter, missingTextureErrors));
        return ret;
    }

    @Nonnull
    public IUnbakedModel process(ImmutableMap<String, String> customData) {
        String flowerPath = (String)customData.get((Object)"flower");
        return new FloatingFlowerModel(new ResourceLocation(flowerPath.substring(1, flowerPath.length() - 1)));
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        TRSRTransformation transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.2f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.5f), null));
        ModelStateComposition comp = new ModelStateComposition((IModelState)transform, sprite.getState());
        IBakedModel bakedFlower = this.unbakedFlower.bake(bakery, spriteGetter, (ISprite)new BasicState((IModelState)comp, false), format);
        HashMap<IFloatingFlower.IslandType, IBakedModel> bakedIslands = new HashMap<IFloatingFlower.IslandType, IBakedModel>();
        for (Map.Entry<IFloatingFlower.IslandType, IUnbakedModel> e : this.unbakedIslands.entrySet()) {
            IBakedModel bakedIsland = e.getValue().bake(bakery, spriteGetter, sprite, format);
            bakedIslands.put(e.getKey(), bakedIsland);
        }
        return new Baked(bakedFlower, bakedIslands);
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("botania_special") && modelLocation.func_110623_a().equals("models/floating_flower");
        }

        @Nonnull
        public IUnbakedModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return INIT;
        }
    }

    public static class Baked
    extends BakedModelWrapper<IBakedModel> {
        private final Map<IFloatingFlower.IslandType, IBakedModel> islands;
        private final Map<IFloatingFlower.IslandType, List<BakedQuad>> genQuads = new HashMap<IFloatingFlower.IslandType, List<BakedQuad>>();
        private final Map<IFloatingFlower.IslandType, Map<Direction, List<BakedQuad>>> faceQuads = new HashMap<IFloatingFlower.IslandType, Map<Direction, List<BakedQuad>>>();

        Baked(IBakedModel flower, Map<IFloatingFlower.IslandType, IBakedModel> islands) {
            super(flower);
            this.islands = islands;
            Random rand = new Random();
            for (Map.Entry<IFloatingFlower.IslandType, IBakedModel> e : islands.entrySet()) {
                rand.setSeed(42L);
                ArrayList gen = new ArrayList(flower.getQuads(null, null, rand, (IModelData)EmptyModelData.INSTANCE));
                rand.setSeed(42L);
                gen.addAll(e.getValue().getQuads(null, null, rand, (IModelData)EmptyModelData.INSTANCE));
                this.genQuads.put(e.getKey(), gen);
                EnumMap fq = new EnumMap(Direction.class);
                for (Direction dir : Direction.values()) {
                    rand.setSeed(42L);
                    ArrayList lst = new ArrayList(flower.getQuads(null, dir, rand, (IModelData)EmptyModelData.INSTANCE));
                    rand.setSeed(42L);
                    lst.addAll(e.getValue().getQuads(null, dir, rand, (IModelData)EmptyModelData.INSTANCE));
                    fq.put(dir, lst);
                }
                this.faceQuads.put(e.getKey(), fq);
            }
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
            return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            IFloatingFlower.IslandType type = IFloatingFlower.IslandType.GRASS;
            if (extraData.hasProperty(BotaniaStateProps.FLOATING_DATA)) {
                type = ((IFloatingFlower)extraData.getData(BotaniaStateProps.FLOATING_DATA)).getIslandType();
            }
            if (side == null) {
                return this.genQuads.get(type);
            }
            return this.faceQuads.get(type).get(side);
        }

        @Nonnull
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
            Pair p = this.islands.values().iterator().next().handlePerspective(cameraTransformType);
            return Pair.of((Object)((Object)this), (Object)p.getRight());
        }
    }
}

