/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;

public final class ShaderHelper {
    public static final FloatBuffer FLOAT_BUF = MemoryUtil.memAllocFloat((int)1);
    public static int pylonGlow = 0;
    public static int enchanterRune = 0;
    public static int manaPool = 0;
    public static int doppleganger = 0;
    public static int halo = 0;
    public static int dopplegangerBar = 0;
    public static int terraPlateRune = 0;
    public static int filmGrain = 0;
    public static int gold = 0;
    public static int categoryButton = 0;
    public static int alpha = 0;
    private static boolean hasIncompatibleMods = false;
    private static boolean checkedIncompatibility = false;
    private static boolean lighting;

    private static void deleteShader(int id) {
        if (id != 0) {
            GLX.glDeleteShader((int)id);
        }
    }

    public static void initShaders() {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)manager -> {
                ShaderHelper.deleteShader(pylonGlow);
                pylonGlow = 0;
                ShaderHelper.deleteShader(enchanterRune);
                enchanterRune = 0;
                ShaderHelper.deleteShader(manaPool);
                manaPool = 0;
                ShaderHelper.deleteShader(doppleganger);
                doppleganger = 0;
                ShaderHelper.deleteShader(halo);
                halo = 0;
                ShaderHelper.deleteShader(dopplegangerBar);
                dopplegangerBar = 0;
                ShaderHelper.deleteShader(terraPlateRune);
                terraPlateRune = 0;
                ShaderHelper.deleteShader(filmGrain);
                filmGrain = 0;
                ShaderHelper.deleteShader(gold);
                gold = 0;
                ShaderHelper.deleteShader(categoryButton);
                categoryButton = 0;
                ShaderHelper.deleteShader(alpha);
                alpha = 0;
                ShaderHelper.loadShaders(manager);
            }));
        }
    }

    private static void loadShaders(IResourceManager manager) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        pylonGlow = ShaderHelper.createProgram(manager, null, "shader/pylon_glow.frag");
        enchanterRune = ShaderHelper.createProgram(manager, null, "shader/enchanter_rune.frag");
        manaPool = ShaderHelper.createProgram(manager, null, "shader/mana_pool.frag");
        doppleganger = ShaderHelper.createProgram(manager, "shader/doppleganger.vert", "shader/doppleganger.frag");
        halo = ShaderHelper.createProgram(manager, null, "shader/halo.frag");
        dopplegangerBar = ShaderHelper.createProgram(manager, null, "shader/doppleganger_bar.frag");
        terraPlateRune = ShaderHelper.createProgram(manager, null, "shader/terra_plate_rune.frag");
        filmGrain = ShaderHelper.createProgram(manager, null, "shader/film_grain.frag");
        gold = ShaderHelper.createProgram(manager, null, "shader/gold.frag");
        categoryButton = ShaderHelper.createProgram(manager, null, "shader/category_button.frag");
        alpha = ShaderHelper.createProgram(manager, "shader/alpha.vert", "shader/alpha.frag");
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        lighting = GL11.glGetBoolean((int)2896);
        GlStateManager.disableLighting();
        GLX.glUseProgram((int)shader);
        if (shader != 0) {
            int time = GLX.glGetUniformLocation((int)shader, (CharSequence)"time");
            GLX.glUniform1i((int)time, (int)ClientTickHandler.ticksInGame);
            if (callback != null) {
                callback.call(shader);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        if (lighting) {
            GlStateManager.enableLighting();
        }
        ShaderHelper.useShader(0);
    }

    public static boolean useShaders() {
        return (Boolean)ConfigHandler.CLIENT.useShaders.get() != false && GLX.usePostProcess && ShaderHelper.checkIncompatibleMods();
    }

    private static boolean checkIncompatibleMods() {
        if (!checkedIncompatibility) {
            hasIncompatibleMods = ModList.get().isLoaded("optifine");
            checkedIncompatibility = true;
        }
        return !hasIncompatibleMods;
    }

    private static int createProgram(IResourceManager manager, String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(manager, vert, GLX.GL_VERTEX_SHADER);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(manager, frag, GLX.GL_FRAGMENT_SHADER);
        }
        if ((program = GLX.glCreateProgram()) == 0) {
            return 0;
        }
        if (vert != null) {
            GLX.glAttachShader((int)program, (int)vertId);
        }
        if (frag != null) {
            GLX.glAttachShader((int)program, (int)fragId);
        }
        GLX.glLinkProgram((int)program);
        if (GLX.glGetProgrami((int)program, (int)GLX.GL_LINK_STATUS) == 0) {
            Botania.LOGGER.warn("Error encountered when linking program containing VS {} and FS {}. Log output:", (Object)vert, (Object)frag);
            Botania.LOGGER.warn(GLX.glGetProgramInfoLog((int)program, (int)32768));
            return 0;
        }
        return program;
    }

    private static int createShader(IResourceManager manager, String filename, int shaderType) {
        int shader = 0;
        try {
            shader = GLX.glCreateShader((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            GLX.glShaderSource((int)shader, (CharSequence)ShaderHelper.readFileAsString(manager, filename));
            GLX.glCompileShader((int)shader);
            if (GLX.glGetShaderi((int)shader, (int)GLX.GL_COMPILE_STATUS) == 0) {
                String s1 = StringUtils.trim((String)GLX.glGetShaderInfoLog((int)shader, (int)32768));
                throw new IOException("Couldn't compile " + filename + ": " + s1);
            }
            return shader;
        }
        catch (Exception e) {
            GLX.glDeleteShader((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String readFileAsString(IResourceManager manager, String filename) throws Exception {
        InputStream in = manager.func_199002_a(new ResourceLocation("botania", filename)).func_199027_b();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

