/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.recipe.IModRecipe;

public class RecipePetals
implements IModRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final ImmutableList<Ingredient> inputs;

    public RecipePetals(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
        this.id = id;
        this.output = output;
        this.inputs = ImmutableList.copyOf((Object[])inputs);
    }

    public boolean matches(IItemHandler inv) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.getSlots() && !(input = inv.getStackInSlot(i)).func_190926_b(); ++i) {
            int stackIndex = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        return ingredientsMissing.isEmpty();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        buf.func_150787_b(this.inputs.size());
        for (Ingredient input : this.inputs) {
            input.func_199564_a(buf);
        }
        buf.writeItemStack(this.output, false);
    }

    public static RecipePetals read(PacketBuffer buf) {
        ResourceLocation id = buf.func_192575_l();
        Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
        }
        ItemStack output = buf.func_150791_c();
        return new RecipePetals(id, output, inputs);
    }
}

