/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.corporea;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaRequestDefaultMatchers;
import vazkii.botania.api.corporea.CorporeaRequestEvent;
import vazkii.botania.api.corporea.ICorporeaInterceptor;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.IWrappedInventory;
import vazkii.botania.api.corporea.InvWithLocation;

public final class CorporeaHelper {
    private static final List<InvWithLocation> empty = ImmutableList.of();
    private static final WeakHashMap<List<ICorporeaSpark>, List<InvWithLocation>> cachedNetworks = new WeakHashMap();
    public static int lastRequestMatches = 0;
    public static int lastRequestExtractions = 0;

    public static List<InvWithLocation> getInventoriesOnNetwork(ICorporeaSpark spark) {
        List<InvWithLocation> cache;
        ICorporeaSpark master = spark.getMaster();
        if (master == null) {
            return empty;
        }
        List<ICorporeaSpark> network = master.getConnections();
        if (cachedNetworks.containsKey(network) && (cache = cachedNetworks.get(network)) != null) {
            return cache;
        }
        ArrayList<InvWithLocation> inventories = new ArrayList<InvWithLocation>();
        if (network != null) {
            for (ICorporeaSpark otherSpark : network) {
                InvWithLocation inv;
                if (otherSpark == null || (inv = otherSpark.getSparkInventory()) == null) continue;
                inventories.add(inv);
            }
        }
        cachedNetworks.put(network, inventories);
        return inventories;
    }

    public static int getCountInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        List<InvWithLocation> inventories = CorporeaHelper.getInventoriesOnNetwork(spark);
        return CorporeaHelper.getCountInNetwork(matcher, inventories);
    }

    public static int getCountInNetwork(ICorporeaRequestMatcher matcher, List<InvWithLocation> inventories) {
        Map<InvWithLocation, Integer> map = CorporeaHelper.getInventoriesWithMatchInNetwork(matcher, inventories);
        return CorporeaHelper.getCountInNetwork(matcher, map);
    }

    public static int getCountInNetwork(ICorporeaRequestMatcher matcher, Map<InvWithLocation, Integer> inventories) {
        int count = 0;
        for (int value : inventories.values()) {
            count += value;
        }
        return count;
    }

    public static Map<InvWithLocation, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        List<InvWithLocation> inventories = CorporeaHelper.getInventoriesOnNetwork(spark);
        return CorporeaHelper.getInventoriesWithMatchInNetwork(matcher, inventories);
    }

    public static Map<InvWithLocation, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, List<InvWithLocation> inventories) {
        HashMap<InvWithLocation, Integer> countMap = new HashMap<InvWithLocation, Integer>();
        List<IWrappedInventory> wrappedInventories = BotaniaAPI.internalHandler.wrapInventory(inventories);
        for (IWrappedInventory inv : wrappedInventories) {
            CorporeaRequest request = new CorporeaRequest(matcher, -1);
            inv.countItems(request);
            if (request.foundItems <= 0) continue;
            countMap.put(inv.getWrappedObject(), request.foundItems);
        }
        return countMap;
    }

    public static ICorporeaRequestMatcher createMatcher(ItemStack stack, boolean checkNBT) {
        return new CorporeaRequestDefaultMatchers.CorporeaItemStackMatcher(stack, checkNBT);
    }

    public static ICorporeaRequestMatcher createMatcher(String name) {
        return new CorporeaRequestDefaultMatchers.CorporeaStringMatcher(name);
    }

    public static List<ItemStack> requestItem(ItemStack stack, ICorporeaSpark spark, boolean checkNBT, boolean doit) {
        return CorporeaHelper.requestItem(CorporeaHelper.createMatcher(stack, checkNBT), stack.func_190916_E(), spark, doit);
    }

    public static List<ItemStack> requestItem(String name, int count, ICorporeaSpark spark, boolean doit) {
        return CorporeaHelper.requestItem(CorporeaHelper.createMatcher(name), count, spark, doit);
    }

    public static List<ItemStack> requestItem(ICorporeaRequestMatcher matcher, int itemCount, ICorporeaSpark spark, boolean doit) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        CorporeaRequestEvent event = new CorporeaRequestEvent(matcher, itemCount, spark, doit);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return stacks;
        }
        List<InvWithLocation> inventories = CorporeaHelper.getInventoriesOnNetwork(spark);
        List<IWrappedInventory> inventoriesW = BotaniaAPI.internalHandler.wrapInventory(inventories);
        HashMap<ICorporeaInterceptor, ICorporeaSpark> interceptors = new HashMap<ICorporeaInterceptor, ICorporeaSpark>();
        CorporeaRequest request = new CorporeaRequest(matcher, itemCount);
        for (IWrappedInventory inv : inventoriesW) {
            ICorporeaSpark invSpark = inv.getSpark();
            InvWithLocation originalInventory = inv.getWrappedObject();
            if (originalInventory.world.func_175625_s(originalInventory.pos) instanceof ICorporeaInterceptor) {
                ICorporeaInterceptor interceptor = (ICorporeaInterceptor)originalInventory.world.func_175625_s(originalInventory.pos);
                interceptor.interceptRequest(matcher, itemCount, invSpark, spark, stacks, inventories, doit);
                interceptors.put(interceptor, invSpark);
            }
            if (doit) {
                stacks.addAll(inv.extractItems(request));
                continue;
            }
            stacks.addAll(inv.countItems(request));
        }
        for (ICorporeaInterceptor interceptor : interceptors.keySet()) {
            interceptor.interceptRequestLast(matcher, itemCount, (ICorporeaSpark)interceptors.get(interceptor), spark, stacks, inventories, doit);
        }
        lastRequestMatches = request.foundItems;
        lastRequestExtractions = request.extractedItems;
        return stacks;
    }

    public static ICorporeaSpark getSparkForInventory(InvWithLocation inv) {
        TileEntity tile = inv.world.func_175625_s(inv.pos);
        return CorporeaHelper.getSparkForBlock(tile.func_145831_w(), tile.func_174877_v());
    }

    public static ICorporeaSpark getSparkForBlock(World world, BlockPos pos) {
        List sparks = world.func_175647_a(Entity.class, new AxisAlignedBB(pos.func_177984_a(), pos.func_177982_a(1, 2, 1)), (Predicate)Predicates.instanceOf(ICorporeaSpark.class));
        return sparks.isEmpty() ? null : (ICorporeaSpark)sparks.get(0);
    }

    public static boolean doesBlockHaveSpark(World world, BlockPos pos) {
        return CorporeaHelper.getSparkForBlock(world, pos) != null;
    }

    public static void clearCache() {
        cachedNetworks.clear();
    }

    public static int signalStrengthForRequestSize(int requestSize) {
        if (requestSize <= 0) {
            return 0;
        }
        if (requestSize >= 16384) {
            return 15;
        }
        return Math.min(15, MathHelper.func_151239_c((int)requestSize) + 1);
    }
}

