/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.world.MysticalFlowerConfig;
import vazkii.botania.common.world.MysticalFlowerFeature;
import vazkii.botania.common.world.MysticalMushroomFeature;

@Mod.EventBusSubscriber(modid="botania", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    public static final Feature<MysticalFlowerConfig> MYSTICAL_FLOWERS = new MysticalFlowerFeature(MysticalFlowerConfig::deserialize);
    public static final Feature<MysticalFlowerConfig> MYSTICAL_MUSHROOMS = new MysticalMushroomFeature(MysticalFlowerConfig::deserialize);
    public static final Set<BiomeDictionary.Type> TYPE_BLACKLIST = ImmutableSet.of((Object)BiomeDictionary.Type.DEAD, (Object)BiomeDictionary.Type.NETHER, (Object)BiomeDictionary.Type.END, (Object)BiomeDictionary.Type.SNOWY, (Object)BiomeDictionary.Type.WASTELAND, (Object)BiomeDictionary.Type.VOID, (Object[])new BiomeDictionary.Type[0]);

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ModBlocks.register(r, MYSTICAL_FLOWERS, "mystical_flowers");
        ModBlocks.register(r, MYSTICAL_MUSHROOMS, "mystical_mushrooms");
    }

    public static void addWorldgen() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (BiomeDictionary.getTypes((Biome)biome).stream().noneMatch(TYPE_BLACKLIST::contains)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(MYSTICAL_FLOWERS, (IFeatureConfig)new MysticalFlowerConfig(), (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
            }
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(MYSTICAL_MUSHROOMS, (IFeatureConfig)new MysticalFlowerConfig(), (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
        }
    }
}

