/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ICompositableLens;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ILensControl;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.Lens;

public class ItemLens
extends ItemMod
implements ILensControl,
ICompositableLens,
ITinyPlanetExcempt {
    public static final int PROP_NONE = 0;
    public static final int PROP_POWER = 1;
    public static final int PROP_ORIENTATION = 2;
    public static final int PROP_TOUCH = 4;
    public static final int PROP_INTERACTION = 8;
    public static final int PROP_DAMAGE = 16;
    public static final int PROP_CONTROL = 32;
    private static final String TAG_COLOR = "color";
    private static final String TAG_COMPOSITE_LENS = "compositeLens";
    private final Lens lens;
    private final int props;

    public ItemLens(Item.Properties builder, Lens lens, int props) {
        super(builder);
        this.lens = lens;
        this.props = props;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        int storedColor = ItemLens.getStoredColor(par1ItemStack);
        if (storedColor != -1) {
            stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.color", new Object[]{new TranslationTextComponent("botania.color" + storedColor, new Object[0])}));
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens.func_190926_b()) {
            return super.func_200295_i(stack);
        }
        String shortKeyA = stack.func_77977_a() + ".short";
        String shortKeyB = compositeLens.func_77977_a() + ".short";
        return new TranslationTextComponent("item.botania.composite_lens", new Object[]{new TranslationTextComponent(shortKeyA, new Object[0]), new TranslationTextComponent(shortKeyB, new Object[0])});
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor != -1) {
            props.color = this.getLensColor(stack);
        }
        ItemLens.getLens(stack).apply(stack, props);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.func_190926_b() && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).apply(compositeLens, props);
        }
    }

    @Override
    public boolean collideBurst(IManaBurst burst, RayTraceResult pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        ThrowableEntity entity = (ThrowableEntity)burst;
        dead = ItemLens.getLens(stack).collideBurst(burst, entity, pos, isManaBlock, dead, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.func_190926_b() && compositeLens.func_77973_b() instanceof ILens) {
            dead = ((ILens)compositeLens.func_77973_b()).collideBurst(burst, pos, isManaBlock, dead, compositeLens);
        }
        return dead;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        ThrowableEntity entity = (ThrowableEntity)burst;
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == 16 && entity.field_70170_p.field_72995_K) {
            burst.setColor(this.getLensColor(stack));
        }
        ItemLens.getLens(stack).updateBurst(burst, entity, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.func_190926_b() && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).updateBurst(burst, compositeLens);
        }
    }

    @Override
    public int getLensColor(ItemStack stack) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == -1) {
            return 0xFFFFFF;
        }
        if (storedColor == 16) {
            return Color.HSBtoRGB((float)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L) / 360.0f, 1.0f, 1.0f);
        }
        return DyeColor.func_196056_a((int)storedColor).field_193351_w;
    }

    public static int getStoredColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR, -1);
    }

    public static void setLensColor(ItemStack stack, int color) {
        ItemNBTHelper.setInt(stack, TAG_COLOR, color);
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    public static boolean isBlacklisted(ItemStack lens1, ItemStack lens2) {
        ICompositableLens item1 = (ICompositableLens)lens1.func_77973_b();
        ICompositableLens item2 = (ICompositableLens)lens2.func_77973_b();
        return (item1.getProps(lens1) & item2.getProps(lens2)) != 0;
    }

    public static Lens getLens(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemLens) {
            return ((ItemLens)stack.func_77973_b()).lens;
        }
        return new Lens();
    }

    @Override
    public boolean canCombineLenses(ItemStack sourceLens, ItemStack compositeLens) {
        ICompositableLens compositeItem;
        ICompositableLens sourceItem = (ICompositableLens)sourceLens.func_77973_b();
        if (sourceItem == (compositeItem = (ICompositableLens)compositeLens.func_77973_b())) {
            return false;
        }
        if (!sourceItem.isCombinable(sourceLens) || !compositeItem.isCombinable(compositeLens)) {
            return false;
        }
        return !ItemLens.isBlacklisted(sourceLens, compositeLens);
    }

    @Override
    public ItemStack getCompositeLens(ItemStack stack) {
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_COMPOSITE_LENS, true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)cmp);
    }

    @Override
    public ItemStack setCompositeLens(ItemStack sourceLens, ItemStack compositeLens) {
        if (!compositeLens.func_190926_b()) {
            CompoundNBT cmp = compositeLens.func_77955_b(new CompoundNBT());
            ItemNBTHelper.setCompound(sourceLens, TAG_COMPOSITE_LENS, cmp);
        }
        return sourceLens;
    }

    @Override
    public int getManaToTransfer(IManaBurst burst, ThrowableEntity entity, ItemStack stack, IManaReceiver receiver) {
        return ItemLens.getLens(stack).getManaToTransfer(burst, entity, stack, receiver);
    }

    @Override
    public boolean shouldPull(ItemStack stack) {
        return stack.func_77973_b() != ModItems.lensStorm;
    }

    @Override
    public boolean isControlLens(ItemStack stack) {
        return (this.getProps(stack) & 0x20) != 0;
    }

    @Override
    public boolean allowBurstShooting(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        return ItemLens.getLens(stack).allowBurstShooting(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderTick(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        ItemLens.getLens(stack).onControlledSpreaderTick(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderPulse(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        ItemLens.getLens(stack).onControlledSpreaderPulse(stack, spreader, redstone);
    }

    @Override
    public int getProps(ItemStack stack) {
        return this.props;
    }

    @Override
    public boolean isCombinable(ItemStack stack) {
        return stack.func_77973_b() != ModItems.lensNormal;
    }
}

