/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.subtile.functional.SubTileHeiseiDream;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class ItemDivaCharm
extends ItemBauble
implements IManaUsingItem {
    public ItemDivaCharm(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDamaged);
    }

    private void onEntityDamaged(LivingHurtEvent event) {
        if (event.getSource().func_76364_f() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity && !event.getEntityLiving().field_70170_p.field_72995_K && Math.random() < (double)0.6f) {
            Runnable lambda = () -> {
                MobEntity target = (MobEntity)event.getEntityLiving();
                PlayerEntity player = (PlayerEntity)event.getSource().func_76364_f();
                ItemStack amulet = EquipmentHandler.findOrEmpty(ModItems.divaCharm, (LivingEntity)player);
                if (!amulet.func_190926_b()) {
                    int cost = 250;
                    if (ManaItemHandler.requestManaExact(amulet, player, 250, false)) {
                        int range = 20;
                        List mobs = player.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(target.field_70165_t - 20.0, target.field_70163_u - 20.0, target.field_70161_v - 20.0, target.field_70165_t + 20.0, target.field_70163_u + 20.0, target.field_70161_v + 20.0), (Predicate)Predicates.instanceOf(IMob.class));
                        if (mobs.size() > 1 && SubTileHeiseiDream.brainwashEntity(target, mobs)) {
                            target.func_70691_i(target.func_110138_aP());
                            target.revive();
                            if (target instanceof CreeperEntity) {
                                ((CreeperEntity)event.getEntityLiving()).field_70833_d = 2;
                            }
                            ManaItemHandler.requestManaExact(amulet, player, 250, true);
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.divaCharm, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            PacketHandler.sendToNearby(target.field_70170_p, (Entity)target, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.DIVA_EFFECT, target.field_70165_t, target.field_70163_u, target.field_70161_v, target.func_145782_y()));
                        }
                    }
                }
            };
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            server.func_212871_a_((Runnable)new TickDelayedTask(server.func_71259_af(), lambda));
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        AccessoryRenderHelper.translateToHeadLevel(player, partialTicks);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.scaled((double)0.8, (double)0.8, (double)0.8);
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translated((double)0.1625, (double)-1.625, (double)0.4);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
    }
}

