/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemBrewBase
extends ItemMod
implements IBrewItem {
    private static final String TAG_BREW_KEY = "brewKey";
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private final int swigs;
    private final int drinkSpeed;
    private final ItemStack baseItem;

    public ItemBrewBase(Item.Properties builder, int swigs, int drinkSpeed, ItemStack baseItem) {
        super(builder);
        this.swigs = swigs;
        this.drinkSpeed = drinkSpeed;
        this.baseItem = baseItem;
        this.func_185043_a(new ResourceLocation("botania", "swigs_taken"), (stack, world, entity) -> swigs - this.getSwigsLeft(stack));
    }

    public int func_77626_a(ItemStack stack) {
        return this.drinkSpeed;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, LivingEntity living) {
        if (!world.field_72995_K) {
            for (EffectInstance effect : this.getBrew(stack).getPotionEffects(stack)) {
                EffectInstance newEffect = new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), true, true);
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a((Entity)living, (Entity)living, living, newEffect.func_76458_c(), 1.0);
                    continue;
                }
                living.func_195064_c(newEffect);
            }
            if (world.field_73012_v.nextBoolean()) {
                world.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof PlayerEntity && !((PlayerEntity)living).field_71075_bZ.field_75098_d) {
                if (swigs == 1) {
                    if (!((PlayerEntity)living).field_71071_by.func_70441_a(this.baseItem.func_77946_l())) {
                        return this.baseItem.func_77946_l();
                    }
                    return ItemStack.field_190927_a;
                }
                this.setSwigsLeft(stack, swigs - 1);
            }
        }
        return stack;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemBrewBase.setBrew(stack, s);
                list.add((Object)stack);
            }
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        TranslationTextComponent cmp = new TranslationTextComponent(this.func_77658_a(), new Object[]{new TranslationTextComponent(this.getBrew(stack).getUnlocalizedName(stack), new Object[0]), new StringTextComponent(Integer.toString(this.getSwigsLeft(stack))).func_211708_a(TextFormatting.BOLD)});
        return cmp;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        Brew brew = this.getBrew(stack);
        for (EffectInstance effect : brew.getPotionEffects(stack)) {
            TextFormatting format = !effect.func_188419_a().func_188408_i() ? TextFormatting.RED : TextFormatting.GRAY;
            TranslationTextComponent cmp = new TranslationTextComponent(effect.func_76453_d(), new Object[0]);
            if (effect.func_76458_c() > 0) {
                cmp.func_150258_a(" ");
                cmp.func_150257_a((ITextComponent)new TranslationTextComponent("botania.roman" + (effect.func_76458_c() + 1), new Object[0]));
            }
            if (!effect.func_188419_a().func_76403_b()) {
                cmp.func_150258_a(" (" + EffectUtils.func_188410_a((EffectInstance)effect, (float)1.0f) + ")").func_211708_a(TextFormatting.GRAY);
            }
            list.add(cmp.func_211708_a(format));
        }
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return BotaniaAPI.getBrewFromKey(key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBrewBase.setBrew(stack, (brew == null ? BotaniaAPI.fallbackBrew : brew).getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew);
    }

    @Nonnull
    public static String getSubtype(ItemStack stack) {
        return stack.func_77942_o() ? ItemNBTHelper.getString(stack, TAG_BREW_KEY, "none") : "none";
    }

    public int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, this.swigs);
    }

    public void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }
}

