/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.network.IMessage;
import vazkii.patchouli.common.network.NetworkHandler;
import vazkii.patchouli.common.network.message.MessageOpenBookGui;

public class ItemLexicon
extends ItemMod
implements IElvenItem {
    public static final String TAG_ELVEN_UNLOCK = "botania:elven_unlock";

    public ItemLexicon(Item.Properties props) {
        super(props);
        this.func_185043_a(new ResourceLocation("botania", "elven"), (stack, world, living) -> this.isElvenItem(stack) ? 1.0f : 0.0f);
    }

    private static Book getBook() {
        return (Book)BookRegistry.INSTANCE.books.get(ModItems.lexicon.getRegistryName());
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((IItemProvider)this));
            ItemStack creative = new ItemStack((IItemProvider)this);
            creative.func_196082_o().func_74757_a(TAG_ELVEN_UNLOCK, true);
            list.add((Object)creative);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (Screen.hasShiftDown()) {
            Book book = ItemLexicon.getBook();
            if (book.contents != null) {
                tooltip.add(new StringTextComponent(book.contents.getSubtitle()).func_211708_a(TextFormatting.GRAY));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.shiftinfo", new Object[0]));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Book book = ItemLexicon.getBook();
        if (playerIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            UseItemSuccessTrigger.INSTANCE.trigger(player, stack, player.func_71121_q(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
            NetworkHandler.sendToPlayer((IMessage)new MessageOpenBookGui(book.resourceLoc.toString()), (ServerPlayerEntity)((ServerPlayerEntity)playerIn));
            SoundEvent sfx = PatchouliSounds.getSound((String)book.openSound, (SoundEvent)PatchouliSounds.book_open);
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, sfx, SoundCategory.PLAYERS, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static String getEdition() {
        return ItemLexicon.getBook().contents.getSubtitle();
    }

    public static ITextComponent getTitle(ItemStack stack) {
        ITextComponent title = stack.func_200301_q();
        String akashicTomeNBT = "akashictome:displayName";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(akashicTomeNBT)) {
            title = new StringTextComponent(stack.func_77978_p().func_74779_i(akashicTomeNBT));
        }
        return title;
    }

    @Override
    public boolean isElvenItem(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_ELVEN_UNLOCK);
    }
}

