/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.loot;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="botania")
public final class LootHandler {
    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        String prefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": 
                case "village_blacksmith": {
                    evt.getTable().addPool(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(LootHandler.getInjectEntry(entryName, 1)).bonusRolls(0.0f, 1.0f).func_216044_b();
    }

    private static LootEntry.Builder getInjectEntry(String name, int weight) {
        ResourceLocation table = new ResourceLocation("botania", "inject/" + name);
        return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(weight);
    }
}

